/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.*;
import java.text.*;
import java.util.*;
import org.netbeans.mdr.persistence.*;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.*;

/**
* This is an index from names (Strings) to MOFIDs.  Its primary use is to 
* store the MOFIDs for secondary indexes.
*/
public class MofidIndex extends NameIndex implements StorageClient {

    /* MOFID generator */
    BtreeStorage storage;

    /** Create a new MofidIndex  */
    public MofidIndex() {
    }

    /** Create a new MofidIndex  */
    public MofidIndex(BtreeStorage storage) {
        super();
        this.storage = storage;
    }

    /** get a MOFID by its name.  If none exists, throw an exception
    * @param name the name associated with the MOFID
    */
    public synchronized MOFID get(String name)throws StorageException  {
    	return (MOFID)getObj(name);
    }

    /**
    * Add a name-MOFID pair to the MofidIndex.  If one already existed,
    * throw an exception.
    * @param name name of object to add to index
    * @param id MOFID of object to add
    */
    public synchronized void add(String name, MOFID id) throws StorageException {
    	addObj(name, id);
    }

    /**
    * write object to stream.  Used by serialization.
    * @param obj object to write
    * @param strm stream to write it to
    */
    protected void writeObjectToStream(Object obj, DataOutputStream strm) 
    	throws StorageException {
            this.storage.writeMOFIDData (strm, (MOFID) obj);
    }

    /**
    * read object from stream.  Used by deserialization.
    * @param strm stream to read from
    * @return obj object read
    */
    protected Object readObjectFromStream(DataInputStream strm) 
    	throws StorageException {
	return this.storage.readMOFIDData (strm);
    }

    /** called on deserialization */
    public void setStorage(Storage storage) {
    	this.storage = ((BtreeStorage)storage);
    }
}



