/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

/** The address of a cached page */
class PageID {
    /** the index of the file this page belongs to */
    int fileIndex;

    /** the offset into the file of this page */
    int offset;

    /** create a PageID
    * @param fIdx file index
    * @param ofset offset
    */
    PageID(int fIdx, int ofst) {
        fileIndex = fIdx;
        offset = ofst;
    }

    /** two page IDs are equal if their file indexes and offsets are equal */
    public boolean equals(Object o) {
        if (!(o instanceof PageID))
            return false;

        PageID page = (PageID)o;
        return page.fileIndex == this.fileIndex &&
               page.offset == this.offset;
    }

    /** hase a pageID on its file index and offset */
    public int hashCode() {
        return fileIndex + offset;
    }

    /** for debugging */
    public String toString() {
        return Integer.toString(fileIndex) + ":" + offset;
    }
}
