/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.memoryimpl;

import java.util.*;
import org.netbeans.mdr.persistence.*;

public class MultivalueLog {
    
    private static final byte OP_ADD = 0;    
    private static final byte OP_REMOVE = 1;
    private static final byte OP_REPLACE = 2;
    private static final byte OP_ADD_ALL = 3;
    
    private static final int NULL_POSITION = -1;
    
    private ArrayList log = new ArrayList ();
    private MultivaluedIndexImpl index;
    private boolean rollingBack = false;
    
    // ..........................................................................    
    
    public MultivalueLog(MultivaluedIndexImpl index) {
        this.index = index;
    }
    
    // ..........................................................................
    
    /**
     * Clears the transaction log.
     */
    public void clear () {
        log.clear ();
    }

    /**
     * Logs add operation.
     */
    public void logAdd (Object key, Object value) {
        if (rollingBack)
            return;
        Record rec = new Record (OP_REMOVE, key, value);
        log.add (0, rec);
    }

    /**
     * Logs add operation.
     */
    public void logAdd (Object key, Object value, int position) {
        if (rollingBack)
            return;
        Record rec = new Record (OP_REMOVE, key, value, position);
        log.add (0, rec);
    }
    
    /**
     * Logs remove operation.
     */
    public void logRemove (Object key, Object value) {
        if (rollingBack)
            return;
        Record rec = new Record (OP_ADD, key, value);
        log.add (0, rec);
    }

    /**
     * Logs remove operation.
     */
    public void logRemove (Object key, Object value, int position) {
        if (rollingBack)
            return;
        Record rec = new Record (OP_ADD, key, value, position);
        log.add (0, rec);
    }
    
    /**
     * Logs remove operation.
     */
    public void logRemoveKey (Object key, Object value) {
        if (rollingBack)
            return;
        Record rec = new Record (OP_ADD_ALL, key, value);
        log.add (0, rec);
    }
    
    /**
     * Logs replace operation.
     */
    public void logReplace (Object key, Object oldValue, int position) {
        if (rollingBack)
            return;
        Record rec = new Record (OP_REPLACE, key, oldValue, position);
        log.add (0, rec);
    }
    
    /**
     * Rolls back all changes performed over the index during the recorded transaction.
     */
    public void rollBack () throws StorageException {
        rollingBack = true;
        Iterator iter = log.iterator();
        while(iter.hasNext()) {            
            Record rec = (Record) iter.next();
            switch (rec.opCode) {
                case OP_ADD:
                    if (rec.position == NULL_POSITION)
                        index.add (rec.key, rec.value);
                    else
                        ((MultivaluedOrderedIndex) index).add (rec.key, rec.position, rec.value);
                    break;
                case OP_REMOVE:
                    if (rec.position == NULL_POSITION)
                        index.remove (rec.key, rec.value);
                    else
                        ((MultivaluedOrderedIndex) index).remove (rec.key, rec.position);
                    break;
                case OP_REPLACE:
                    ((MultivaluedOrderedIndex) index).replace (rec.key, rec.position, rec.value);
                    break;
                case OP_ADD_ALL:
                    index.setKey (rec.key, rec.value);
            }
        }
        rollingBack = false;
    }

    // Record ...................................................................

    private static class Record {
        
        byte opCode; // operation code
        Object key;
        Object value;
        int position;

        public Record (byte opCode, Object key, Object value, int position) {
            this.opCode = opCode;
            this.key = key;
            this.value = value;
            this.position = position;
        }
        
        public Record (byte opCode, Object key, Object value) {
            this.opCode = opCode;
            this.key = key;
            this.value = value;
            this.position = NULL_POSITION;
        }
        
    } // Record

}
