/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.memoryimpl;

import org.netbeans.mdr.persistence.*;
import java.util.ArrayList;
import java.util.List;

/** Default memory implementation of the MultivaluedOrderedIndex using Hashtable.
 * @author  Pavel Buzek, Martin Matula
 * @version
 */
public class MultivaluedOrderedIndexImpl extends MultivaluedIndexImpl implements MultivaluedOrderedIndex, Streamable {
    
    /** Creates new MultivaluedOrderedIndexImpl */
    public MultivaluedOrderedIndexImpl(String name, StorageImpl storage, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique) {
        super (name, storage, keyType, valueType, unique);
    }

    public MultivaluedOrderedIndexImpl() {
    }

    public synchronized java.util.List getItemsOrdered(Object key) throws StorageException {
        return (List) getItems (key);
    }

      /** Like getItemsOrdered, but if the index contains keys, this returns the objects 
     * corresponding to the key
     * @return
     * @param key
     * @throws StorageException
     */
    public synchronized java.util.Collection getObjectsOrdered (Object key, SinglevaluedIndex repos) throws StorageException {
    	return (List) getObjects(key, repos);
    }

    /** Removes the element at the specified position in the list of values
     * associated with the specified key.
     */
    public synchronized boolean remove(Object key,int index) throws StorageException {
        List vals = (List) entries.get (key);
        Object orig;
        if (vals != null && (orig = vals.remove(index)) != null) {
            transLog.logRemove(key, orig, index);
            return true;
        } else {
            return false;
        }
    }
    
    /** Inserts the specified element at the specified position in the list of values
     * associated with the specified key.
     */
    public synchronized void add(Object key,int index,Object value) throws StorageException {
        List vals = (List) entries.get (key);
        if (vals == null) {
            vals = new ArrayList ();
            entries.put(key, vals);
        } else if (unique && vals.contains(value)) {
            throw createValueAlreadyContainedExc(key, value);
        }
        vals.add(index, value);
        transLog.logAdd(key, value, index);
    }
    
    /** Replaces the element at the specified position in the list of values
     * associated with the specified key with the specified element.
     * Throws StorageBadRequestException if the index is out of range.
     * @param key
     * @param index
     * @param element
     * @throws StorageException
     */
    public synchronized void replace(Object key,int index,Object element) throws StorageException {
        List vals = (List) entries.get (key);
        try {
            Object orig;
            if (vals != null) {
                if (unique && !isUniqueValue(vals, element, index)) {
                    throw createValueAlreadyContainedExc(key, element);
                }
                if ((orig = vals.set(index, element)) != null) {
                    transLog.logReplace(key, orig, index);
                    return;
                }
            }
        } catch (IndexOutOfBoundsException e) {
        }
        throw new StorageBadRequestException ("Index out of range: " + index + " for key: " + key);
    }
}
