/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.memoryimpl;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.mdr.persistence.*;

/**
 *
 * @author  pbuzek
 * @version 
 */
public class StorageFactoryImpl extends Object implements StorageFactory {
    public static final String STORAGE_ID = "org.netbeans.mdr.persistence.memoryimpl.id";
    public static final String STORAGE_NAME = "org.netbeans.mdr.persistence.memoryimpl.fileName";
    static final String NULL_STORAGE_ID = ".";
    private static final MOFID NULL_MOFID = new MOFID(0, NULL_STORAGE_ID);

    private StorageImpl nullStorage; 
    
    private static final HashMap storages = new HashMap();

    /** Creates new StorageFactoryImpl */
    public StorageFactoryImpl() {
    }

    /** Creates instance of class that implements Storage interface.
     * throws StorageException if the name is not valid name of a Storage
     */
    public synchronized Storage createStorage(Map properties) throws StorageException {
        String name = (String) properties.get(STORAGE_ID);  // Not mandatory
        if (name == null || name.equals(NULL_STORAGE_ID)) {
            if (nullStorage == null) {
                nullStorage = new StorageImpl(NULL_STORAGE_ID, null);
            }
            return nullStorage;
        } else {
            synchronized (storages) {
                if (storages.containsKey(name)) {
                    throw new RuntimeException("Storage '" + name + "' already created.");
                } else {
                    Storage result = new StorageImpl(name, (String) properties.get(STORAGE_NAME));
                    storages.put(name, result);
                    return result;
                }                
            }
        }
    }
    
    /** Serializes content of the given storage. Returns false if the storage was not found. 
     */
    public static boolean serialize(String storageId) throws StorageException {
        StorageImpl storage;
        synchronized (storages) {
            storage = (StorageImpl) storages.get(storageId);
        }
        if (storage == null) {
            return false;
        }
        storage.serialize();
        return true;
    }
    
    public org.netbeans.mdr.persistence.MOFID createNullMOFID() throws StorageException {
        return NULL_MOFID;
    }
}
