/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.storagemodel;

import org.netbeans.mdr.util.Logger;

import java.util.*;

import javax.jmi.reflect.*;

import org.netbeans.mdr.persistence.*;
import org.netbeans.mdr.util.DebugException;

/**
 *
 * @author Martin Matula
 */
public class AssocEndIndexSet extends IndexImmutSet implements TypedCollection {
    protected final MOFID metaMofId;
    protected final MOFID metaMofIdOther;
    protected final Class type;
    protected final int maxSize;
    protected final StorableAssociation storable;
    protected final Index secondIndex;
    protected final boolean mutable;
    protected final boolean isAggregate;
    protected final boolean isAggregateOther;
    protected final boolean isIndexed;
    protected final boolean isIndexedOther;
    protected final StorableObject keyObject;

    protected AssocEndIndexSet(StorableAssociation storable, MOFID metaMofId, MOFID metaMofIdOther, MultivaluedIndex index, Object indexKey, Index secondIndex, Class type, int max, boolean mutable, boolean isAggregate, boolean isAggregateOther, boolean isIndexed, boolean isIndexedOther) {
        super(storable.getMdrStorage(), index, indexKey);
        this.metaMofId = metaMofId;
        this.metaMofIdOther = metaMofIdOther;
        this.type = type;
        this.maxSize = max;
        this.storable = storable;
        this.secondIndex = secondIndex;
        this.mutable = mutable;
        this.isAggregate = isAggregate;
        this.isAggregateOther = isAggregateOther;
        this.isIndexed = isIndexed;
        this.isIndexedOther = isIndexedOther;
        
        if (isAggregate || isAggregateOther || isIndexed) {
            try {
                keyObject = (StorableObject) storage.getObject((MOFID) indexKey);
            } catch (StorageException e) {
                throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
            }
        } else {
            keyObject = null;
        }
    }

    public void checkType(Object obj) {
        if (!mutable) throw new UnsupportedOperationException();
        
        if (obj == null) {
            throw new NullPointerException();
        }
        
        if (!type.isInstance(obj)) {
            throw new TypeMismatchException(type, obj, getMetaElement());
        }
    }
    
    protected void checkMaxSize(int size) {
        if (type == null) {
            throw new UnsupportedOperationException();
        } else if (maxSize != -1) {
            if (maxSize < size + size()) throw new WrongSizeException(getMetaElement());
        }
    }

    protected RefObject getMetaElement() {
        try {
            return (RefObject) storage.getRepository().getHandler(storage.getObject(metaMofId));
        } catch (Exception e) {
            return null;
        }
    }
    
    public Iterator iterator() {
        return new IndexIterator(getObjects().iterator());
    }
    
    public boolean remove(Object o) {
        try {
            StorableObject so = null;
            
            if (isAggregate) {
                keyObject.clearComposite();
            } else if (isAggregateOther) {
                if (so == null)
                    so = (StorableObject) storage.getObject((MOFID) o);
                so.clearComposite();
            }
            
            if (isIndexed) {
                keyObject.removeFromIndex (metaMofId);
            }
            if (isIndexedOther) {
                if (so == null)
                    so = (StorableObject) storage.getObject((MOFID) o);
                so.removeFromIndex (metaMofIdOther);
            }
                        
            boolean result = this.index.remove(indexKey, o);
            if (result) {
                if (secondIndex instanceof SinglevaluedIndex) {
                    secondIndex.remove(o);
                } else {
                    ((MultivaluedIndex) secondIndex).remove(o, indexKey);
                }                
            }
            if (isIndexed) {
                keyObject.addToIndex (metaMofId);
            }
            if (isIndexedOther) {                
                so.addToIndex (metaMofIdOther);
            }
            
            return result;
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }        
    
    public boolean add(Object obj) {
        checkMaxSize(1);
        try { 
            StorableObject so = null;
            if (isAggregate) {                
                keyObject.setComposite((MOFID) obj, (MOFID) obj, metaMofId);
            } else if (isAggregateOther) {
                if (so == null)
                    so = (StorableObject) storage.getObject((MOFID) obj);
                so.setComposite(keyObject, (MOFID) obj, metaMofId);
            }
            if (isIndexed) {                
                keyObject.removeFromIndex (metaMofId);
            }
            if (isIndexedOther) {
                if (so == null)
                    so = (StorableObject) storage.getObject((MOFID) obj);
                so.removeFromIndex (metaMofIdOther);
            }
            index.add(indexKey, obj);
            secondIndex.add(obj, indexKey);
            if (isIndexed) {
                keyObject.addToIndex (metaMofId);
            }
            if (isIndexedOther) {                
                so.addToIndex (metaMofIdOther);
            }
            return true;
        } catch (StorageBadRequestException e) {
            // duplicate element -> return false
            return false;
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }
    
    public boolean removeAll(Collection collection) {
        // should never be called
        throw new DebugException();
    }
    
    public boolean addAll(Collection collection) {
        // should never be called
        throw new DebugException();
    }
    
    public boolean retainAll(Collection collection) {
        // should never be called
        throw new DebugException();
    }
    
    public void clear() {
        // should never be called
        throw new DebugException();
    }
    
    protected class IndexIterator extends IndexImmutIterator {
        protected Object lastRead = null;
        
        protected IndexIterator(Iterator innerIterator) {
            super(innerIterator);
        }
        
        public Object next() {
            return (lastRead = super.next());
        }
        
        public void remove() {
            innerIterator.remove();
            try {
                if (isAggregate) {
                    keyObject.clearComposite();
                } else if (isAggregateOther) {
                    ((StorableObject) lastRead).clearComposite();
                }

                if (isIndexed) {
                    keyObject.removeFromIndex (metaMofId);
                }
                if (isIndexedOther) {
                    ((StorableObject) lastRead).removeFromIndex (metaMofIdOther);
                }
                
                MOFID key = ((StorableBaseObject) lastRead).getMofId ();
                if (secondIndex instanceof MultivaluedIndex) {
                    ((MultivaluedIndex) secondIndex).remove(key, indexKey);
                } else {
                    secondIndex.remove(key);
                }
                
                if (isIndexed) {
                    keyObject.addToIndex (metaMofId);
                }
                if (isIndexedOther) {                
                    ((StorableObject) lastRead).addToIndex (metaMofIdOther);
                }                
            } catch (StorageException e) {
                throw new DebugException();
            }
        }
    }
}
