/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.storagemodel;

import java.util.*;

import javax.jmi.reflect.*;

import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.persistence.*;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;

/**
 *
 * @author Martin Matula
 */
public class AssocEndIndexUList extends AssocEndIndexSet implements List {
    private final MultivaluedOrderedIndex orderedIndex;
    
    protected AssocEndIndexUList(StorableAssociation storable, MOFID metaMofId, MOFID metaMofIdOther, MultivaluedOrderedIndex index, Object indexKey, Index secondIndex, Class type, int max, boolean mutable, boolean isAggregate, boolean isAggregateOther, boolean isIndexed, boolean isIndexedOther) {
        super(storable, metaMofId, metaMofIdOther, index, indexKey, secondIndex, type, max, mutable, isAggregate, isAggregateOther, isIndexed, isIndexedOther);
        this.orderedIndex = index;
    }
    
    protected List getItemsList() {
        try {
            return orderedIndex.getItemsOrdered(indexKey);
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }
    
    protected List getObjectsList() {
        try {
            return (List) storage.getObjectsFromIndex(index, indexKey);

        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }
    
    public Object get(int param) {
        return getObjectsList().get(param);
    }
    
    public ListIterator listIterator() {
        return new IndexListIterator (getObjectsList().listIterator());
    }
    
    public ListIterator listIterator(int param) {
        return new IndexListIterator (getObjectsList().listIterator(param));
    }
    
    public int indexOf(Object obj) {
        return getItemsList().indexOf(obj);
    }
    
    public int lastIndexOf(Object obj) {
        return getItemsList().lastIndexOf(obj);
    }
    
    public List subList(int param, int param1) {
        throw new UnsupportedOperationException();
//        return new SubListImpl(param, param1, listIterator(param));
    }

    public Object set(int index, Object object) {
        try { 
            Object oldValue = ((List) getItems()).get(index);

            if (isAggregate) {
                keyObject.clearComposite();
                keyObject.setComposite((MOFID) object, (MOFID) object, metaMofId);
            } else if (isAggregateOther) {
                ((StorableObject) storage.getObject((MOFID) oldValue)).clearComposite();
                ((StorableObject) storage.getObject((MOFID) object)).setComposite(keyObject, (MOFID) object, metaMofId);
            }

            if (isIndexed) {
                keyObject.removeFromIndex (metaMofId);
            }
            if (isIndexedOther) {
                ((StorableObject) storage.getObject((MOFID) oldValue)).removeFromIndex (metaMofIdOther);
                ((StorableObject) storage.getObject((MOFID) object)).removeFromIndex (metaMofIdOther);
            }
            
            orderedIndex.replace(indexKey, index, object);
            if (secondIndex instanceof SinglevaluedIndex) {
                secondIndex.remove(oldValue);
            } else {
                ((MultivaluedIndex) secondIndex).remove(oldValue, indexKey);
            }
            secondIndex.add(object, indexKey);
            
            if (isIndexed) {
                keyObject.addToIndex (metaMofId);
            }
            if (isIndexedOther) {
                ((StorableObject) storage.getObject((MOFID) oldValue)).addToIndex (metaMofIdOther);
                ((StorableObject) storage.getObject((MOFID) object)).addToIndex (metaMofIdOther);
            }
            
            return storage.getObject((MOFID) oldValue);
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }
    
    public void add(int index, Object element) {
        try { 
            checkMaxSize(1);
            StorableObject so = null;
            if (isAggregate) {
                keyObject.setComposite((MOFID) element, (MOFID) element, metaMofId);
            } else if (isAggregateOther) {
                if (so == null)
                    so = (StorableObject) storage.getObject((MOFID) element);
                so.setComposite(keyObject, (MOFID) element, metaMofId);
            }            
            if (isIndexed) {
                keyObject.removeFromIndex (metaMofId);
            }
            if (isIndexedOther) {
                if (so == null)
                    so = (StorableObject) storage.getObject((MOFID) element);
                so.removeFromIndex (metaMofIdOther);
            }

            try {
                orderedIndex.add(indexKey, index, element);
            } catch (StorageBadRequestException e) {
                throw new IndexOutOfBoundsException();
            }
            secondIndex.add(element, indexKey);
            
            if (isIndexed) {
                keyObject.addToIndex (metaMofId);
            }
            if (isIndexedOther) {                
                so.addToIndex (metaMofIdOther);
            }
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }
    
    public Object remove(int index) {
        try { 
            Object oldValue = getItemsList().get(index);
            StorableObject so = null;
            if (isAggregate) {
                keyObject.clearComposite();
            } else if (isAggregateOther) {
                if (so == null)
                    so = (StorableObject) storage.getObject((MOFID) oldValue);
                so.clearComposite();
            }
            
            if (isIndexed) {
                keyObject.removeFromIndex (metaMofId);
            }
            if (isIndexedOther) {
                if (so == null)
                    so = (StorableObject) storage.getObject((MOFID) oldValue);
                so.removeFromIndex (metaMofIdOther);
            }
            
            orderedIndex.remove(indexKey, index);
            if (secondIndex instanceof SinglevaluedIndex) {
                secondIndex.remove(oldValue);
            } else {
                ((MultivaluedIndex) secondIndex).remove(oldValue, indexKey);
            }
            
            if (isIndexed) {
                keyObject.addToIndex (metaMofId);
            }
            if (isIndexedOther) {                
                so.addToIndex (metaMofIdOther);
            }
            
            return storage.getObject((MOFID) oldValue);
        } catch (StorageException e) {
            throw new DebugException();
        }
    }
    
    public boolean addAll(int param, Collection collection) {
        // should never be called
        throw new DebugException();
    }
    
    protected class IndexListIterator extends IndexIterator implements ListIterator {
        private final ListIterator listIterator;
        
        protected IndexListIterator(ListIterator innerIterator) {
            super(innerIterator);
            listIterator = innerIterator;
        }
        
        public void add(Object obj) {
            listIterator.add(obj);
            try {
                if (isAggregate) {
                    keyObject.setComposite((MOFID) obj, (MOFID) obj, metaMofId);
                } else if (isAggregateOther) {
                    ((StorableObject) storage.getObject((MOFID) obj)).setComposite(keyObject, (MOFID) obj, metaMofId);
                }
                if (isIndexed) {
                    keyObject.removeFromIndex (metaMofId);
                }
                if (isIndexedOther) {
                    ((StorableObject) storage.getObject((MOFID) obj)).removeFromIndex (metaMofIdOther);
                }
                secondIndex.add(obj, indexKey);
                if (isIndexed) {
                    keyObject.addToIndex (metaMofId);
                }
                if (isIndexedOther) {
                    ((StorableObject) storage.getObject((MOFID) obj)).addToIndex (metaMofIdOther);
                }
            } catch (StorageException e) {
                throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
            }
        }
        
        public boolean hasPrevious() {
            return listIterator.hasPrevious();
        }
        
        public int nextIndex() {
            return listIterator.nextIndex();
        }
        
        public Object previous() {
            return (lastRead = listIterator.previous());
        }
        
        public int previousIndex() {
            return listIterator.previousIndex();
        }
        
        public void set(Object obj) {
            MOFID key = ((StorableBaseObject) lastRead).getMofId ();
            listIterator.set(obj);
            try {
                if (isAggregate) {
                    keyObject.clearComposite();
                    keyObject.setComposite((MOFID) obj, (MOFID) obj, metaMofId);
                } else if (isAggregateOther) {
                    ((StorableObject) lastRead).clearComposite();
                    ((StorableObject) lastRead).setComposite(keyObject, (MOFID) key, metaMofId);
                }
             
                if (isIndexed) {
                    keyObject.removeFromIndex (metaMofId);
                }
                if (isIndexedOther) {
                    ((StorableObject) lastRead).removeFromIndex (metaMofIdOther);
                    ((StorableObject) storage.getObject((MOFID) obj)).removeFromIndex (metaMofIdOther);
                }
                
                if (secondIndex instanceof MultivaluedIndex) {
                    ((MultivaluedIndex) secondIndex).remove(key, indexKey);
                } else {
                    secondIndex.remove(key);
                }
                secondIndex.add(obj, indexKey);
                
                if (isIndexed) {
                    keyObject.addToIndex (metaMofId);
                }
                if (isIndexedOther) {
                    ((StorableObject) lastRead).addToIndex (metaMofIdOther);
                    ((StorableObject) storage.getObject((MOFID) obj)).addToIndex (metaMofIdOther);
                }
                
            } catch (StorageException e) {
                throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
            }
        }
    }
}
