/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.storagemodel;

import java.util.*;
import java.io.*;

import javax.jmi.reflect.*;

import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.util.IOUtils;

/**
 * @author Martin Matula
 */
public class AttrImmutList extends AbstractList {
    
    protected Object[] data;
    private String typeName;
    
    public AttrImmutList() {
    }
    
    AttrImmutList(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc) throws StorageException {
        this(mdrObject, desc, null);
    }
    
    AttrImmutList(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc, Collection values) throws StorageException {
        Class type = desc.getType();
        if (RefEnum.class.isAssignableFrom(type) || RefStruct.class.isAssignableFrom(type)) {
            typeName = type.getName();
        } else {
            typeName = null;
        }
        
        if (values == null) {
            data = new Object[0];
        } else {
            data = values.toArray();
            for (int i = 0; i < data.length; i++) {
                if (data[i] == null) {
                    throw new NullPointerException();
                }
                if (!type.isInstance(data[i])) {
                    throw new TypeMismatchException(type, data[i], getMetaElement(mdrObject.getMdrStorage(), desc.getMofId()));
                }
            }
        }

        if ((data.length < desc.getMinSize()) || ((desc.getMaxSize() > -1) && (data.length > desc.getMaxSize()))) {
            throw new WrongSizeException(getMetaElement(mdrObject.getMdrStorage(), desc.getMofId()));
        }

        if (type.isInstance(RefObject.class)) {
            setAttribComposite(mdrObject.getMofId(), values, desc.getMofId());
        }
    }
    
    protected void setAttribComposite(MOFID compositeId, RefObject object, MOFID metaMofId) throws StorageException {        
        StorableObject storable = (StorableObject) ((BaseObjectHandler) object)._getDelegate();
        storable.setComposite(compositeId, storable.getMofId(), metaMofId);
    }
    
    protected void setAttribComposite(MOFID compositeId, Collection list, MOFID metaMofId) throws StorageException {
        for (Iterator it = list.iterator(); it.hasNext();) {
            setAttribComposite(compositeId, (RefObject) it.next(), metaMofId);
        }
    }        

    protected RefObject getMetaElement(MdrStorage mdrStorage, MOFID mofId) {
        try {
            return (RefObject) mdrStorage.getRepository().getHandler(mdrStorage.getObject(mofId));
        } catch (Exception e) {
            return null;
        }
    }
    
    public Object get(int index) {
        return data[index];
    }
    
    public int size() {
        return data.length;
    }
    
    public void read(InputStream stream, StorableBaseObject storable) throws IOException {
        typeName = (String) storable.getMdrStorage().values(storable.getMofId()).resolve(IOUtils.readInt(stream));
        int size = IOUtils.readInt(stream);
        data = new Object[size];
        for (int i = 0; i < size; i++) {
            data[i] = IOUtils.read(stream, storable);
        }
    }
    
    public void write(OutputStream stream, StorableBaseObject storable) throws IOException {
        IOUtils.writeInt(stream, storable.getMdrStorage().values(storable.getMofId()).indexOf(typeName));
        IOUtils.writeInt(stream, data.length);
        for (int i = 0; i < data.length; i++) {
            IOUtils.write(stream, data[i], storable);
        }
    }
}
