/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.storagemodel;

import java.util.*;

import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.DuplicateException;
import org.netbeans.mdr.persistence.MOFID;

import org.netbeans.mdr.persistence.StorageException;

/**
 *
 * @author Martin Matula
 */
public class AttrSet extends AttrCollection {
    public AttrSet() {
        inner = new HashSet();
    }
    
    AttrSet(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc) throws StorageException {
        this(mdrObject, desc, null);
    }
    
    protected AttrSet(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc, Collection values) throws StorageException {
        super(mdrObject, desc, null);

        if (values != null) {
            checkMaxSize(values.size());
            inner = new HashSet(values.size() * 2);
            for (Iterator it = values.iterator(); it.hasNext();) {
                Object value = it.next();
                checkType(value);
                if (!inner.add(value)) {
                    throw new DuplicateException(value, getMetaElement());
                }
                if (isRefObject) {
                    setAttribComposite((RefObject) value);
                }
            }
        } else {
            inner = new HashSet();
        }
    }

    protected void checkUnwrap() {
        if (needsUnwrap) {
            HashSet old = (HashSet) inner;
            inner = new HashSet();
            for (Iterator it = old.iterator(); it.hasNext();) {
                Object temp = it.next();
                if (temp instanceof MOFID) {
                    inner.add(mdrObject.getMdrStorage().getRepository().getByMofId((MOFID) temp));
                } else {
                    inner.add(temp);
                }
            }
            needsUnwrap = false;
        }
    }
}
