/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.storagemodel;

import java.util.*;

import java.io.InputStream;
import java.io.IOException;

import javax.jmi.reflect.*;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;

/**
 *
 * @author Martin Matula
 */
public class AttrUList extends AttrList {
    private Set innerSet = null;
    
    public AttrUList() {
        super();
    }
    
    AttrUList(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc) throws StorageException {
        this(mdrObject, desc, null);
    }
    
    public AttrUList(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc, List values) throws StorageException {
        super(mdrObject, desc, values);
        
        innerSet = new HashSet();
        for (Iterator it = inner.iterator(); it.hasNext();) {
            Object value = it.next();
            if (!innerSet.add(value)) {
                throw new DuplicateException(value, getMetaElement());
            }
        }
    }

    protected AttrUList(StorableFeatured mdrObject, List values, int maxSize, Class type, String attrName, boolean isRefObject, MOFID metaMofId, Set innerSet) {
        super(mdrObject, values, maxSize, type, attrName, isRefObject, metaMofId);
        this.innerSet = innerSet;
    }
    
    protected void checkUnwrap() {
        if (innerSet == null) {
            super.checkUnwrap();
            innerSet = new HashSet(inner);
        }
    }

    public boolean remove(Object obj) {
        super.remove(obj);
        return innerSet.remove(obj);
    }
    
    public Object set(int param, Object obj) {
        Object retValue;
        retValue = super.set(param, obj);
        innerSet.remove(retValue);
        if (!innerSet.add(obj)) {
            throw new DuplicateException(obj, getMetaElement());
        }
        return retValue;
    }
    
    public ListIterator listIterator(int param) {
        checkUnwrap();
        return new AttrUListIterator(innerList.listIterator(param));
    }
    
    public Iterator iterator() {
        checkUnwrap();
        return new AttrUListIterator(innerList.listIterator());
    }
    
    public ListIterator listIterator() {
        checkUnwrap();
        return new AttrUListIterator(innerList.listIterator());
    }
    
    public Object remove(int param) {
        Object retValue;
        retValue = super.remove(param);
        innerSet.remove(retValue);
        return retValue;
    }
    
    public void add(int param, Object obj) {
        super.add(param, obj);
        if (!innerSet.add(obj)) {
            throw new DuplicateException(obj, getMetaElement());
        }
    }
    
    public boolean add(Object obj) {
        super.add(obj);
        return innerSet.add(obj);
    }
    
    public List subList(int param, int param1) {
        checkUnwrap();
        return new AttrUList(mdrObject, innerList.subList(param, param1), maxSize, type, attrName, isRefObject, metaMofId, innerSet);
    }
    
    public boolean contains(Object obj) {
        checkUnwrap();
        return innerSet.contains(obj);
    }
    
    public boolean containsAll(Collection collection) {
        checkUnwrap();
        return innerSet.containsAll(collection);
    }
    
    protected class AttrUListIterator extends AttrListIterator {
        protected AttrUListIterator(ListIterator iterator) {
            super(iterator);
        }
        
        public void remove() {
            super.remove();
            innerSet.remove(lastRead);
        }
        
        public void add(Object obj) {            
            if (!innerSet.add(obj)) {
                throw new DuplicateException(obj, getMetaElement());
            }
            super.add(obj);
        }
        
        public void set(Object obj) {
            super.set(obj);
            innerSet.remove(lastRead);
            if (!innerSet.add(obj)) {
                throw new DuplicateException(obj, getMetaElement());
            }
        }
    }
}
