/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.storagemodel;

import java.io.*;
import java.util.*;

import javax.jmi.model.*;
import javax.jmi.reflect.*;

import org.netbeans.mdr.persistence.*;
import org.netbeans.mdr.util.*;
import org.netbeans.mdr.handlers.BaseObjectHandler;

/** Superclass for repository objects that can have features (class proxies, instances)
 *
 * @author Martin Matula, Petr Hrebejk
 * @version 0.3
 */
public abstract class StorableFeatured extends StorableBaseObject implements Streamable {
    /** Creates new StorableFeatured providing all needed arguments.
     * @param mdrStorage parent MdrStorage
     * @param immediatePackage MOFID of immediate package
     * @param meta MOFID of metaobject
     * @throws StorageException problem in storage
     */
    public StorableFeatured(MdrStorage mdrStorage, org.netbeans.mdr.persistence.MOFID immediatePackage, org.netbeans.mdr.persistence.MOFID meta) throws StorageException {
        this (mdrStorage, immediatePackage, meta, null);
    }
    
    public StorableFeatured (MdrStorage mdrStorage, org.netbeans.mdr.persistence.MOFID immediatePackage, org.netbeans.mdr.persistence.MOFID meta, String storageId) throws StorageException {
        super (mdrStorage, immediatePackage, meta, storageId);
    }

    /** Creates new StorableFeatured. 
     * (This default constructor is used only during deserialization of repository
     * object and is immediately followed by call to {@link read} method.)
     */
    public StorableFeatured() {
        super();
    }
    
    protected void checkValue(StorableClass.AttributeDescriptor desc, Object value) {
        if (desc.getMofId() == null) return;
        if (desc.isMultivalued() || !desc.isChangeable()) {
            throw new InvalidCallException(getMdrStorage().getRepository().getHandler(this), getMetaElement(desc.getMofId()));
        } else {
            if (value == null) {
                if (desc.getMinSize() > 0) {
                    throw new NullPointerException();
                }
            } else {
                if (!desc.getType().isInstance(value)) {
                    throw new TypeMismatchException(desc.getType(), value, getMetaElement(desc.getMofId()));
                }
            }
        }
    }
    
    private void checkInitValue(StorableClass.AttributeDescriptor desc, Object value) {
        if (desc.getMofId() == null) return;        
        if (desc.isMultivalued()) {
            throw new InvalidCallException(getMdrStorage().getRepository().getHandler(this), getMetaElement(desc.getMofId()));
        }
        if ((value != null) && !desc.getType().isInstance(value)) {
            throw new TypeMismatchException(desc.getType(), value, getMetaElement(desc.getMofId()));
        }
    }
    
    protected Object getInitialValue(StorableClass.AttributeDescriptor desc, Object value) throws StorageException {
        Object result;
        if (desc.isMultivalued()) {
            if (desc.isChangeable()) {
                if (desc.isUnique()) {
                    result = desc.isOrdered() ? (Collection) new AttrUList(this, desc, (List) value) : (Collection) new AttrSet(this, desc, (Collection) value);
                } else {
                    result = desc.isOrdered() ? (Collection) new AttrList(this, desc, (List) value) : (Collection) new AttrCollection(this, desc, (Collection) value);
                }
            } else {
                result = desc.isUnique() ? (List) new AttrImmutUList(this, desc, (Collection) value) : (List) new AttrImmutList(this, desc, (Collection) value);
            }
        } else {
            try {
                checkInitValue (desc, value);
            } catch (RuntimeException e) {
                Logger.getDefault().annotate(e, "multivalued: " + desc.isMultivalued() + ", name: " + desc.getName());
                Logger.getDefault().annotate(e, "maxSize: " + desc.getMaxSize() + ", minSize: " + desc.getMinSize());
                throw e;
            }
            result = value;
            if (result instanceof RefObject) {
                StorableObject storableObj = (StorableObject) ((BaseObjectHandler) result)._getDelegate();
                storableObj.setComposite(this, storableObj.getMofId(), desc.getMofId());
            }
        } // else
        return result;
    }
    
    private RefObject getMetaElement(org.netbeans.mdr.persistence.MOFID mofId) {
        try {
            return (RefObject) getMdrStorage().getRepository().getHandler(getMdrStorage().getObject(mofId));
        } catch (StorageException e) {
            Logger.getDefault().notify(Logger.INFORMATIONAL, e);
            return null;
        }
    }
    
    /** 
     * @param feature MOFID of attribute metaobject
     * @param value new value of the specified attribute
     * @throws StorageException problem in storage
     */
    public abstract void setAttribute(String featureName, Object value) throws StorageException;
    
    public abstract Object getAttribute(String featureName) throws StorageException;
    
    public abstract StorableClass getClassProxy() throws StorageException;
}
