/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.storagemodel;

import java.util.*;

/**
 *
 * @author Martin Matula
 */
abstract class SubListImpl implements List {
    private final int firstIndex;
    private final int lastIndex;
    private final ListIterator innerIterator;

    /** Creates new SubListImpl */
    public SubListImpl(int firstIndex, int lastIndex, ListIterator iterator) {
        this.firstIndex = firstIndex;
        this.lastIndex = lastIndex;
        this.innerIterator = iterator;
    }

    public int size() {
        return lastIndex - firstIndex;
    }
    
    public ListIterator listIterator(int index) {
        return innerIterator;
    }
    
    private abstract class SubListIterator implements ListIterator {
        private int currentIndex;
        
        private SubListIterator(int fromIndex) {
            currentIndex = fromIndex;
        }
        

    }
}
