/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.storagemodel;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.transientimpl.*;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.mdr.util.DebugException;
/**
 *
 * @author Tomas Zezula
 */
public class TransientStorableAssociation extends StorableAssociation implements Transient {
    
    private static final String FORMAT = "{0}-{1}-{2}"; // No I18N
    
    
    
    private boolean uniqueA;
    private boolean uniqueB;
    
    private transient Index atIndex;
    private transient Index btIndex;
    
    /** Creates a new instance of TransientStorableAssociation */
    public TransientStorableAssociation() {
    }
    
    /** Creates new instance of association proxy providing all needed arguments.
     * @param mdrStorage parent storage of created association proxy being created
     * @param immediatePackage MOFID of association proxy immediate package
     * @param MOFID of meta association proxy meta object
     * @param endAMofid MOFID of the first association end
     * @param endBMofid MOFID of the second association end
     * @param multiValuedA <code>true</code> if the first end is multivalued
     * @param multiValuedB <code>true</code> if the second end is multivalued
     * @param orderedA <code>true</code> if the first end is ordered
     * @param orderedB <code>true</code> if the second end is ordered
     * @param uniqueA <code>true</code> if the first end is unique
     * @param uniqueB <code>true</code> if the second end is unique
     * @param aggrA <code>true</code> if the first end is aggregate
     * @param aggrB <code>true</code> if the second end is aggregate
     * @throws StorageException problem in storage occurred during association proxy creation
     */
    public TransientStorableAssociation(MdrStorage mdrStorage, org.netbeans.mdr.persistence.MOFID immediatePackage, org.netbeans.mdr.persistence.MOFID meta,
        String endA, org.netbeans.mdr.persistence.MOFID endAId, String endB, org.netbeans.mdr.persistence.MOFID endBId, Class typeA, Class typeB,
        int minA, int maxA, int minB, int maxB, boolean orderedA, boolean orderedB,
        boolean uniqueA, boolean uniqueB, boolean aggrA, boolean aggrB) throws StorageException {
        super(mdrStorage, immediatePackage, meta, endA, endAId, endB, endBId,  typeA, typeB,
        minA, maxA, minB, maxB, orderedA, orderedB, uniqueA, uniqueB, aggrA, aggrB, false, false);
        this.uniqueA = uniqueA;
        this.uniqueB = uniqueB;
    }
    
    public void write(java.io.OutputStream outputStream) {
        try {
            IOUtils.writeBoolean (outputStream, this.uniqueA);
            IOUtils.writeBoolean (outputStream, this.uniqueB);
        } catch (java.io.IOException ioe) {
            throw new DebugException ();
        }
        super.write(outputStream);
    }
    
    public void read(java.io.InputStream inputStream) {
        try {
            this.uniqueA = IOUtils.readBoolean (inputStream);
            this.uniqueB = IOUtils.readBoolean (inputStream);
        } catch (java.io.IOException ioe) {
            throw new DebugException ();
        }        
        super.read(inputStream);
    }
    
    /**
     * @param multi
     * @param ordered
     * @param unique
     * @param end
     * @throws StorageException
     * @return
     */
    protected Index createIndex(boolean multi, boolean ordered, boolean unique, int end) throws StorageException {
        Index result = null;
        String name = this.getIndexName (end);
        if (multi) {
            if (ordered) {
                result = this.getMdrStorage().getTransientStorage().createMultivaluedOrderedIndex (name, Storage.EntryType.MOFID, Storage.EntryType.MOFID, unique);
            }
            else {
                result = this.getMdrStorage().getTransientStorage().createMultivaluedIndex (name, Storage.EntryType.MOFID, Storage.EntryType.MOFID, unique);
            }
        }
        else {
            result = this.getMdrStorage().getTransientStorage().createSinglevaluedIndex (name, Storage.EntryType.MOFID, Storage.EntryType.MOFID);
        }
        
        if (end == 1) {
            this.atIndex = result;
        }
        else {
            this.btIndex = result;
        }
        return result;
    }
    
    
    /** Find the appropriate index in the storage.
     */
    protected Index findIndex(int end) throws StorageException {
        if (end == 1) {
            if (this.atIndex == null) {
                String name = this.getIndexName (end);
                this.atIndex = this.getMdrStorage ().getTransientStorage ().getIndex (name);
                // Is MDR restart or only drop of StorableAssociation from memory
                if (this.atIndex == null) {
                    // Reinitialize after MDR restart
                    this.atIndex = this.createIndex (this.isMultivaluedA (), this.isOrderedA (), this.isUniqueA (), end);
                }
            }
            return this.atIndex;
        }
        else {
            if (this.btIndex == null) {
                String name = this.getIndexName (end);
                this.btIndex = this.getMdrStorage ().getTransientStorage ().getIndex (name);
                // Is MDR restart or only drop of StorableAssociation from memory
                if (this.btIndex == null) {
                    // Reinitialize after MDR restart
                    this.btIndex = this.createIndex (this.isMultivaluedB (), this.isOrderedB (), this.isUniqueB (), end);
                }
            }
            return this.btIndex;
        }
    }
    
    
    protected void deleteIndex(String opkgId, String mofId, int end) throws StorageException {
        String name = this.getIndexName (end);
        this.getMdrStorage ().getTransientStorage ().dropIndex (name);
        if (end == 1)
            this.atIndex = null;
        else
            this.btIndex = null;
    }
    
    protected boolean isUniqueA() {
        return this.uniqueA;
    }
    
    protected boolean isUniqueB() {
        return this.uniqueB;
    }
    
    private String getIndexName (int end) {
        return MessageFormat.format(FORMAT, new Object[] {this.getOutermostPackageId(), this.getMofId(), new Integer(end)});
    }
    
    
}
