/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.storagemodel;
import java.lang.ref.WeakReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.List;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageBadRequestException;
/**
 *
 * @author Tomas Zezula
 */
public class TransientStorableClass extends StorableClass implements Transient {
    
    
    /** Creates a new instance of TransientStorableClass */
    public TransientStorableClass() {
        super ();
    }
    
    public TransientStorableClass(MdrStorage mdrStorage, org.netbeans.mdr.persistence.MOFID packageId, org.netbeans.mdr.persistence.MOFID metaId,
        List attrDescs, List clAttrDescs, Map datatypes, boolean classDerived,
        boolean instanceDerived, boolean isSingleton, boolean isAbstract) throws StorageException {
            super (mdrStorage, packageId, metaId, attrDescs, clAttrDescs, datatypes, classDerived, instanceDerived, isSingleton, isAbstract);
    }
    
    public Collection allObjects (boolean subclasses) throws StorageException {
        if (subclasses) {
            return super.allObjects (subclasses);
        }
        else {
            return collectInstances ();
        }
    }
    
    public boolean isTransient () {
        return true;
    }
    
    
    
    private synchronized Collection collectInstances () throws StorageException {
        MdrStorage storage = this.getMdrStorage ();
        return new IndexImmutSet(storage, storage.getTransientStorage ().getMultivaluedIndex (MdrStorage.IDX_OBJECTS_BY_CLASSES), this.getMofId ());
    }
    
    
}
