/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.util;

import java.util.*;

/**
 *
 * @author Martin Matula
 * @version 
 */
public class ComposedLazyList extends AbstractList {
    private final List lists = new ArrayList();
    private int elementCount = 0;
    
    /** Creates new ComposedLazyList */
    public ComposedLazyList() {
        super();
    }

    public ComposedLazyList(Collection col) {
        this();
        addAll(col);
    }
    
    public boolean addAll(Collection col) {
        List result = (col instanceof List) ? (List) col : new ArrayList(col);
        
        this.modCount++;
        
        elementCount += result.size();
        return lists.add(result);
    }
    
    public int size() {
        return elementCount;
    }
    
    public Object get(int index) {
        int listUBound = 0;
        int listLBound = 0;
        List currentList = null;
        
        for (Iterator it = lists.iterator(); it.hasNext() && listUBound <= index; listUBound += currentList.size()) {
            currentList = (List) it.next();
            listLBound = listUBound;
        }

        return currentList.get(index - listLBound);
    }
    
    public Iterator iterator() {
        return new LazyIterator();
    }
    
    private class LazyIterator implements Iterator {
        Iterator listIterator;
        Iterator currentIterator;
        
        private LazyIterator() {
            listIterator = ComposedLazyList.this.lists.iterator();
            currentIterator = null;
        }
            
        public void remove() {
            throw new UnsupportedOperationException();
        }
        
        public Object next() {
            hasNext();
            return currentIterator.next();
        }
        
        public boolean hasNext() {
            if (currentIterator == null) {
                if (listIterator.hasNext()) {
                    currentIterator = ((List) listIterator.next()).iterator();
                } else {
                    return false;
                }
            }
            
            while (!currentIterator.hasNext()) {
                if (listIterator.hasNext()) {
                    currentIterator = ((List) listIterator.next()).iterator();
                } else {
                    return false;
                }
            }
            return true;
        }
    }
}
