/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.util;

import java.util.LinkedList;
import java.util.WeakHashMap;

/**
 *
 * @author Martin Matula
 * @version 
 */
public class RWMutex {
    private Thread thread = null;
    private int counter = 0;
    private final RWMutex dependent;

    /** Creates new Mutex */
    public RWMutex() {
        dependent = null;
    }
    
    /** Creates new mutex which will lock the provided dependent mutex for reading.
     * @param dependent mutex that will be locked by this mutex for reading
     */
    public RWMutex(RWMutex dependent) {
        this.dependent = dependent;
    }

    public synchronized void enter(boolean writer) {
        Thread thread = Thread.currentThread();
        while (counter > 0 && this.thread != thread) {
            try {
                this.wait();
            } catch (InterruptedException e) {
                Logger.getDefault().notify(Logger.INFORMATIONAL, e);
            }               
        }
        
        this.thread = thread;
        counter++;
        if (dependent != null) dependent.enter(false);
    }
    
    public synchronized void leave() {
        if (dependent != null) dependent.leave();
        counter--;
        this.notifyAll();
    }
}
