/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.test;

import org.openide.util.*;
import org.netbeans.mdr.NBMDRManagerImpl;
import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.lib.jmi.mapping.JMIMapperImpl;

import java.util.*;

/**
 *
 * @author  mmatula
 * @version 
 */
public class MDRTestLookup extends Lookup {
    
    private ArrayList instances = null;

    /** Creates new RepositoryLookup */
    public MDRTestLookup() {
    }

    public Object lookup(Class cls) {
        if (instances == null) {
            instances = new ArrayList();
            instances.add(new NBMDRManagerImpl());
            instances.add(new XMISaxReaderImpl());
            instances.add(new JMIMapperImpl());
            instances.add(new XMIWriterImpl());
        }
        for (Iterator it = instances.iterator(); it.hasNext();) {
            Object instance = it.next();
            if (cls.isAssignableFrom(instance.getClass())) {
                return instance;
            }
        }
        return null;
    }
    
    public Lookup.Result lookup(Lookup.Template template) {        
        return new Result(lookup(template.getType()));
    }
    
    private static class Result extends Lookup.Result {
        private final ArrayList result = new ArrayList();
        
        public Result(Object o) {
            if (o != null) result.add(o);
        }
        
        /** Registers a listener that is invoked when there is a possible
         * change in this result.
         *
         * @param l the listener to add
         */
        public void addLookupListener(LookupListener l) {
            // this lookup never changes so nothing need to be registered
        }
        
        /** Get all instances in the result.
         * @return collection of all instances
         */
        public java.util.Collection allInstances() {
            return result;
        }
        
        /** Unregisters a listener previously added.
         * @param l the listener to remove
         */
        public void removeLookupListener(LookupListener l) {
            // nothing was registered
        }
    }
}
