/**
 * Simple MDR test
 */

package org.netbeans.mdr.test;

import java.io.*;
import java.util.*;
import java.beans.*;

import junit.framework.*;
import junit.extensions.*;

import org.netbeans.api.mdr.*;
import org.openide.util.Lookup;
import org.openide.filesystems.*;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.lib.jmi.mapping.*;
import org.netbeans.junit.*;
import org.netbeans.modules.mdr.FSSFImpl;

import javax.jmi.model.ModelPackage;
import javax.jmi.reflect.*;
import javax.xml.parsers.ParserConfigurationException;

public class MDRGenerationTest extends NbTestCase implements MDRTestConstants {
    
    private MDRepository repository = null;
    private String work_dir = null;
    private String file_sep = null;
    
    public MDRGenerationTest(String testName) {
        super(testName);
    }
    
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public static NbTest suite() {
        
        NbTestSuite suite = new NbTestSuite();
        suite.addTestSuite(MDRGenerationTest.class);
        
        NbTestSetup setup = new NbTestSetup(suite) {
            public void setUp() {
                org.netbeans.mdr.handlers.BaseObjectHandler.setDefaultClassLoader(
                this.getClass().getClassLoader() );
            }
            public void tearDown() {
                System.out.println("Saving MDR data ...");
                NBMDRepositoryImpl.saveAll();
            }
        };
        
        return setup;
        
    }
    
    public void testGenIntfsForTestModel_1() {
        loadModel(TEST_MODEL, "data/testmodel_1.xml");
        generateInterfaces(TEST_MODEL);
    }
    
    public void testGenIntfsForTestModel_2() {
        loadModel(TEST_MODEL2, "data/testmodel_2.xml");
        generateInterfaces(TEST_MODEL2);
    }
    
    public void testGenIntfsForFilesystemsModel() {
        loadModel(FILESYSTEMS_MODEL, "data/filesystems.xml");
        generateInterfaces(FILESYSTEMS_MODEL);
    }
        
    
    public void testGenIntfsForJavaModel() {
        loadModel(FILESYSTEMS_MODEL, "data/java.xml");
        generateInterfaces(JAVA_MODEL);
    } 
    
    private void generateInterfaces(String pkg_name) {
        
        FileSystem targetFS = new LocalFileSystem();
        File intf_dir = null;
        
        try {
            intf_dir = new File(work_dir + file_sep + "interfaces");
            intf_dir.mkdir();
            ((LocalFileSystem) targetFS).setRootDirectory(intf_dir);
        } catch (PropertyVetoException e) {
            fail("Unable to create JavaDataObject!\n" + e);
        } catch (IOException e) {
            fail("Unable to create JavaDataObject!\n" + e);
        }
        
        ModelPackage pkg = getPackage(pkg_name);
        JMIMapper jmi_mapper = (JMIMapper) Lookup.getDefault().lookup(JMIMapper.class);
        
        assertNotNull(jmi_mapper);        
        System.out.println("MDRGenerationTest - generating interfaces for package: " + pkg);
        try {
            jmi_mapper.generate(new FSSFImpl(targetFS), pkg);
        } catch (java.io.IOException ioe) {
            fail(ioe.toString());
        }
        
    }
    
    private ModelPackage getPackage(String name) {        
        ModelPackage vmp = null;        
        try {
            vmp = (ModelPackage) repository.getExtent(name);
        } catch (Exception e) {
            fail("Model not loaded, name not resolved.");
        }
        return vmp;        
    }
    
    private void loadModel(String name, String xmi_location) {
        ModelPackage mp = null;
        mp = (ModelPackage) repository.getExtent(name);
        if ( mp == null ) {
            try {
                ModelPackage model = (ModelPackage) repository.createExtent(name);
                XMIReader xmiReaderTest = XMIReader.getDefault();
                xmiReaderTest.read(MDRLoadModelTest.class.getResource(xmi_location).toExternalForm(), new RefPackage[] { model } );
            } catch (Exception  exc) {                
                fail(exc.toString());
            }
        } else {
            // Model is probably loaded
        }
    }
    
    protected void setUp() {
        
        work_dir = System.getProperty("work.dir");
        file_sep = System.getProperty("file.separator");
        
        // properties will be set only if running outside of IDE
        if (System.getProperty("org.openide.version") == null) {
            System.setProperty("org.netbeans.mdr.persistence.Dir", work_dir + file_sep + "test_repository_1");
            System.setProperty("org.netbeans.mdr.storagemodel.StorageFactoryClassName",
            "org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeFactory");
            System.setProperty("org.openide.util.Lookup", "org.netbeans.mdr.test.MDRTestLookup");
            System.setProperty("org.netbeans.mdr.LoadStorage", "true");
            System.setProperty("org.netbeans.mdr.SaveStorageOnExit", "true");
        }
        
        repository = MDRManager.getDefault().getDefaultRepository();
        if (repository == null) {
            fail("Repository not found!");
        } else {
            // start up the repository
            repository.getExtentNames();
        }
        
    }
    
    protected void tearDown() {
        
    }
    
}
