/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.test;

import java.util.*;

import junit.framework.*;
import junit.extensions.*;

import org.netbeans.api.mdr.*;
import org.openide.util.Lookup;

import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.junit.*;

import javax.jmi.model.*;
import javax.jmi.model.ModelPackage;
import javax.jmi.reflect.*;
import javax.xml.parsers.ParserConfigurationException;

import java.io.File;

public class MDRLoadModelTest extends NbTestCase implements MDRTestConstants {
    
    private MDRepository repository = null;
    
    public MDRLoadModelTest(String testName) {
        super(testName);
    }
    
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public static NbTest suite() {
        
        NbTestSuite suite = new NbTestSuite();
        suite.addTestSuite(MDRLoadModelTest.class);
        
        NbTestSetup setup = new NbTestSetup(suite) {
            public void setUp() {
                org.netbeans.mdr.handlers.BaseObjectHandler.setDefaultClassLoader( 
                this.getClass().getClassLoader() );
            }
            public void tearDown() {
                System.out.println("Saving MDR data ...");
                NBMDRepositoryImpl.saveAll();
            }
        };
        
        return setup;
        
    }
    
    public void testLoadTestModel_1() {
        
        ModelPackage mp = null;
        
        try {
            System.out.println("Loading Test Model ..." );
            mp = (ModelPackage) repository.getExtent(TEST_MODEL);
        } catch (Exception e) {
            // We have to create the model
            System.out.println("Name not resolved, loading ...");
        }
        if (mp == null) {
            loadModel(TEST_MODEL, "data/testmodel_1.xml");
        }
        
        assertTrue("Model " + TEST_MODEL + " was not loaded!", 
               isModelLoaded(TEST_MODEL));
        
    }
    
    public void testLoadTestModel_2() {
        
        ModelPackage mp = null;
        
        try {
            System.out.println("Loading Inheritance Model ..." );
            mp = (ModelPackage) repository.getExtent(TEST_MODEL2);
        } catch (Exception e) {
            // We have to create the model
            System.out.println("Name not resolved, loading ...");
        }
        if (mp == null) {
            loadModel(TEST_MODEL2, "data/testmodel_2.xml");
        }
        
        assertTrue("Model " + TEST_MODEL2 + " was not loaded!", 
               isModelLoaded(TEST_MODEL2));
        
    }
    
    public void testLoadFilesystemsModel() {
        
        ModelPackage mp = null;
        
        try {
            System.out.println("Loading Inheritance Model ..." );
            mp = (ModelPackage) repository.getExtent(FILESYSTEMS_MODEL);
        } catch (Exception e) {
            // We have to create the model
            System.out.println("Name not resolved, loading ...");
        }
        if (mp == null) {
            loadModel(FILESYSTEMS_MODEL, "data/filesystems.xml");
        }
        
        assertTrue("Model " + FILESYSTEMS_MODEL + " was not loaded!", 
               isModelLoaded(FILESYSTEMS_MODEL));
        
    }
    
    public void testLoadJavaModel() {
        
        ModelPackage mp = null;
        
        try {
            System.out.println("Loading Java Model ..." );
            mp = (ModelPackage)repository.getExtent(JAVA_MODEL);
        } catch (Exception e) {
            // We have to create the model
            System.out.println("Name not resolved, loading ...");
        }
        if (mp == null) {
            loadModel(JAVA_MODEL, "data/java.xml");
        }
        
        assertTrue("Model " + JAVA_MODEL + " was not loaded!", 
               isModelLoaded(JAVA_MODEL));
        
    }

    private void loadModel(String name, String xmi_location) {
        
        try {
            ModelPackage model = (ModelPackage) repository.createExtent(name);
            XMIReader xmiReaderTest = XMIReader.getDefault();
            xmiReaderTest.read(MDRLoadModelTest.class.getResource(xmi_location).toExternalForm(), new RefPackage[] { model } );
        } catch (Exception  exc) {            
            fail(exc.toString());
        }
        
    }
    
    private boolean isModelLoaded(String name) {
        
        ModelPackage vmp = null;
        
        try {
            vmp = (ModelPackage) repository.getExtent(name);
        } catch (Exception e) {
            fail("Model not loaded, name not resolved.");
        }
        if (vmp != null && vmp instanceof ModelPackage) {
            return true;
        } else {
            return false;
        }
        
    }
    
    protected void setUp() {
        
        String workDir = System.getProperty("work.dir");        
        
        // properties will be set only if running outside of IDE
        if (System.getProperty("org.openide.version") == null) {
            System.setProperty("org.netbeans.mdr.persistence.Dir", workDir + File.separator + "test_repository_1");
            System.setProperty("org.netbeans.mdr.storagemodel.StorageFactoryClassName",
            "org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeFactory");
            System.setProperty("org.openide.util.Lookup", "org.netbeans.mdr.test.MDRTestLookup");
            System.setProperty("org.netbeans.mdr.SaveStorageOnExit", "true");
        }
        
        repository = MDRManager.getDefault().getDefaultRepository();
        if (repository == null) {
            fail("Repository not found!");
        } else {
            // start up the repository
            repository.getExtentNames();
        }
        
    }
    
    protected void tearDown() {
        
    }
    
}
