/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.test;

import java.io.*;
import java.util.*;
import java.net.*;

import junit.extensions.*;
import junit.framework.*;

import org.netbeans.api.xmi.*;
import org.netbeans.api.xmi.sax.*;
import org.openide.util.Lookup;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.lib.jmi.mapping.*;

import org.xml.sax.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

import text.*;

/**
 * Test case verifying functionality of XmiReader and XmiWriter.
 */
public class AdvancedXMITest extends MDRTestCase {

    public static final int N = 3;
    public static String [] name = new String [N];
    public static File [] file = new File [N];
    
    static {
        name [0] = "temp.xml";
        name [1] = "extFile_A.xml";
        name [2] = "extFile_B.xml";
        
        for (int x = 0; x < N; x++) {
            file [x] = getFile (name [x]);            
        }
    }
    
    public AdvancedXMITest(String testName) {
        super (testName);
    }
    
    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite ());
    }
    
    public static Test suite () {
        TestSuite suite = new TestSuite ();
        suite.addTestSuite (AdvancedXMITest.class);
        
        TestSetup setup = new TestSetup (suite) {
            public void setUp () {
            }
            public void tearDown () {
            }
        };        
        return setup;
    }

    // **************************************************************************

    public void testEncoding () {
        RefPackage pkg = instantiateModel ("Text.xml", "Text", "EncodingPkg_1");
        new RandomDataGenerator ().generate (pkg, 0, 6);
        
        Lookup lookup = Lookup.getDefault ();
        
        XMIWriter writer = XMIWriterFactory.getDefault ().createXMIWriter ();
        XMIReader reader = XMIReaderFactory.getDefault ().createXMIReader ();
        writer.getConfiguration().setEncoding("UTF-8");

        final String name = "test_encod.xml";
        try {
            OutputStream os = new FileOutputStream (getFile(name));
            repository.beginTrans (true);
            writer.write (os, name, pkg, null);
            os.flush ();
            os.close ();
        } catch (Exception e) {
            e.printStackTrace();
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }
        
        RefPackage pkg_2 = instantiateModel ("Text.xml", "Text", "EncodingPkg_2");
        try {
            repository.beginTrans (true);
            reader.read (getFile (name).toURL ().toExternalForm (), pkg_2);
        } catch (Exception e) {            
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }
        
        compareData (pkg, pkg_2, new HashSet ());
        deleteModel (pkg);
        
    }
    
    // **************************************************************************
    
    public void testConsumerProducer () {
        RefPackage pkg = instantiateModel ("Java.xml", "Core", "ConsumerPkg_1");
        new RandomDataGenerator ().generate (pkg, 122, 8);
        RefPackage pkg_2 = instantiateModel ("Java.xml", "Core", "ConsumerPkg_2");
        
        Lookup lookup = Lookup.getDefault ();
        
        XMIProducer producer = XMIProducerFactory.getDefault ().createXMIProducer ();
        XMIConsumer consumer = XMIConsumerFactory.getDefault ().createXMIConsumer ();                
        
        producer.setSource (pkg);
        producer.setContentHandler (consumer);
        consumer.setExtent (pkg_2);
        
        try {
            producer.parse ((String) null);                
        } catch (Exception e) {
            fail (e.getMessage ());
        }
        
        compareData (pkg, pkg_2, new HashSet ());
        
        deleteModel (pkg);
        deleteModel (pkg_2);        
    }
    
    // **************************************************************************
    
    public void testReferenceProvider () {
        RefPackage pkg = instantiateModel ("Java.xml", "Core", "Provider_1");
        new RandomDataGenerator ().generate (pkg, 0, 7);
        
        Lookup lookup = Lookup.getDefault ();
        
        XMIWriter writer = XMIWriterFactory.getDefault ().createXMIWriter ();
        XMIReader reader = XMIReaderFactory.getDefault ().createXMIReader ();
        writer.getConfiguration().setReferenceProvider(new Provider ());
        
        for (int x = 0; x < N; x++) {
            try {
                OutputStream os = new FileOutputStream (file [x]);
                repository.beginTrans (true);
                writer.write (os, name [x], pkg, null);
                os.flush ();
                os.close ();
            } catch (Exception e) {
                e.printStackTrace();
                fail (e.getMessage ());
            } finally {
                repository.endTrans ();
            }
        }                    
        
        RefPackage pkg_2 = instantiateModel ("Java.xml", "Core", "Provider_2");
        try {
            repository.beginTrans (true);
            reader.read (file[0].toURL ().toExternalForm (), pkg_2);
        } catch (Exception e) {            
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }
        
        compareData (pkg, pkg_2, new HashSet ());
    
        deleteModel (pkg);
        deleteModel (pkg_2);
    }
    
    // **************************************************************************
    
    public void testReferenceResolver () {
        RefPackage pkg = instantiateModel ("Text.xml", "Text", "Resolver_1");
        new RandomDataGenerator ().generate (pkg, 0, 3);
        
        Lookup lookup = Lookup.getDefault ();
        
        XMIWriter writer = XMIWriterFactory.getDefault ().createXMIWriter ();
        XMIReader reader = XMIReaderFactory.getDefault ().createXMIReader ();
        writer.getConfiguration().setReferenceProvider(new TextProvider ());
        reader.getConfiguration().setReferenceResolver(new TextResolver ());
        
        try {
            OutputStream os = new FileOutputStream (getFile("textExp.xml"));
            repository.beginTrans (true);
            writer.write (os, "textExp.xml", pkg, null);
            os.flush ();
            os.close ();
        } catch (Exception e) {
            e.printStackTrace();
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }
        
        try {
            OutputStream os = new FileOutputStream (getFile("words.xml"));
            repository.beginTrans (true);
            writer.write (os, "words.xml", pkg, null);
            os.flush ();
            os.close ();
        } catch (Exception e) {
            e.printStackTrace();
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }
        
        File file = getFile ("textExp.xml");
        RefPackage pkg_2 = instantiateModel ("Text.xml", "Text", "Resolver_2");
        try {
            repository.beginTrans (true);
            reader.read (file.toURL ().toExternalForm (), pkg_2);
        } catch (Exception e) {            
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }
        
        // compareData (pkg, pkg_2, new HashSet ());
        deleteModel (pkg);
        deleteModel (pkg_2);
    }

    // **************************************************************************
    
    public void testHeaderProvider () {
        RefPackage pkg = instantiateModel ("Java.xml", "Core", "HeaderProvider_1");
        new RandomDataGenerator ().generate (pkg, 0, 3);
        
        Lookup lookup = Lookup.getDefault ();
        
        XMIWriter writer = XMIWriterFactory.getDefault ().createXMIWriter ();
        XMIReader reader = XMIReaderFactory.getDefault ().createXMIReader ();
        ((OutputConfig)writer.getConfiguration()).setHeaderProvider(new HeaderProvider ());
        ((InputConfig)reader.getConfiguration()).setHeaderConsumer(new HeaderConsumer ());
                
        try {
            OutputStream os = new FileOutputStream (getFile("headerTest.xml"));
            repository.beginTrans (true);
            writer.write (os, null, pkg, null);
            os.flush ();
            os.close ();
        } catch (Exception e) {
            e.printStackTrace();
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }
        
        File file = getFile ("headerTest.xml");
        RefPackage pkg_2 = instantiateModel ("Java.xml", "Core", "HeaderProvider_2");
        try {
            repository.beginTrans (true);
            reader.read (file.toURL ().toExternalForm (), pkg_2);
        } catch (Exception e) {            
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }

        compareData (pkg, pkg_2, new HashSet ());
        deleteModel (pkg);
        deleteModel (pkg_2);
        
    }
    
    // **************************************************************************        
    
    /**
     * Creates extent for a metamodel specified by an XMI document.
     *
     * @param docName XMI document name
     * @param mainPackageName name of a MofPackage (included in XMI document) to instantiate
     *
     * @return created extent
     */
    private RefPackage instantiateModel (String docName, String mainPackageName, String metaPkgName) {
        ModelPackage pkg = loadMOFModel (docName, metaPkgName);
        RefPackage result = createExtent (
            findMofPackage (pkg, mainPackageName),
            metaPkgName + "_"
        );
        return result;
    }
    
    private void deleteModel (RefPackage pkg) {
        RefPackage meta = pkg.refMetaObject ().refOutermostPackage ();
        pkg.refDelete ();
        meta.refDelete ();
    }
    
    /**
     * Compares instances counts in packages, fails if there is a proxy with different number
     * of instantiated objects in each package.
     */
    private void compareData (RefPackage pkg_1, RefPackage pkg_2, Set checkedPackages) {
        Set set = new HashSet ();
        checkedPackages.add (pkg_1);
        Iterator iter = pkg_1.refAllClasses ().iterator ();
        while (iter.hasNext ()) {
            RefClass proxy = (RefClass) iter.next ();
            ModelElement meta = (ModelElement) proxy.refMetaObject ();
            int count = proxy.refAllOfClass ().size ();
            int count2 = pkg_2.refClass (meta).refAllOfClass ().size ();
            if (count != count2)
                fail ("Number of instances does not match: " + meta.getName () + " " + count + " " + count2);
        }
        iter = pkg_1.refAllAssociations ().iterator ();
        while (iter.hasNext ()) {
            RefAssociation proxy = (RefAssociation) iter.next ();
            ModelElement meta = (ModelElement) proxy.refMetaObject ();
            int count = proxy.refAllLinks ().size ();
            int count2 = pkg_2.refAssociation (meta).refAllLinks ().size ();
            if (count != count2)
                fail ("Number of links does not match: " + meta.getName () + " " + count + " " + count2);
        }
        iter = pkg_1.refAllPackages ().iterator ();
        while (iter.hasNext ()) {
            RefPackage p1 = (RefPackage) iter.next ();
            ModelElement meta = (ModelElement) p1.refMetaObject ();
            RefPackage p2 = pkg_2.refPackage (meta);
            compareData (p1, p2, checkedPackages);
        }
    }
    
    // Providers & Resolvers ....................................................
    
    public static class Provider implements XMIReferenceProvider {
        
        public XMIReferenceProvider.XMIReference getReference (RefObject obj) {     
            return new XMIReferenceProvider.XMIReference (name [obj.hashCode () % N], obj.refMofId ());
        }
        
    }
    
    public static class TextProvider implements XMIReferenceProvider {
        
        public XMIReferenceProvider.XMIReference getReference (RefObject obj) {
            String systemId;
            String xmiId = obj.refMofId ();
            if (((MofClass)obj.refMetaObject ()).getName ().equals ("Word"))
                systemId = "words.xml";
            else
                systemId = "textExp.xml";
            return new XMIReferenceProvider.XMIReference (systemId, xmiId);
        }
        
    }
    
    public static class TextResolver implements XMIReferenceResolver {
        
        public void register(String systemId, String xmiId, RefObject object) {
        }
        
        public void resolve(Client client, RefPackage extent, String systemId, XMIInputConfig configuration, Collection hrefs) {
            Iterator iter = hrefs.iterator ();
            while (iter.hasNext ()) {
                String href = (String) iter.next ();
                WordClass proxy = ((TextPackage) extent).getWord ();
                client.resolvedReference (href, proxy.createWord ());
            } // while
        }                
    
    }
    
    // Header provider & consumer ...............................................
    
    public static class HeaderProvider implements XMIHeaderProvider {
        
        public void writeHeader (Writer writer) {
            try {
                writer.write("<XMI.documentation>\n\r");
                writer.write("    <XMI.exporter>Netbeans XMI Writer</XMI.exporter>\n\r");
                writer.write("    <XMI.exporterVersion>1.0</XMI.exporterVersion>\n\r");
                writer.write("</XMI.documentation>\n\r");
            } catch (IOException e) {
                e.printStackTrace ();
                fail (e.getMessage ());
            }
        }
        
    }
    
    public static class HeaderConsumer implements XMIHeaderConsumer {
        
        public void consumeHeader (InputStream stream) {
            System.out.println("HEADER:");
            try {
                int b = stream.read ();
                while (b != -1) {
                    System.out.print("" + ((char)b));
                    b = stream.read ();
                }
            } catch (IOException e) {
            }
        }
        
    }
    
}
