/*
 * FederationTest.java
 *
 * Created on May 24, 2002, 8:05 PM
 */

package org.netbeans.mdr.test;

import java.io.*;
import java.util.*;
import java.net.*;
import java.text.MessageFormat;

import junit.extensions.*;
import junit.framework.*;

import org.netbeans.api.mdr.*;
import org.openide.util.Lookup;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.lib.jmi.mapping.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

/**
 *
 * @author  Tomas Zezula
 */
public class FederationTest extends MDRTestCase {
    
    private static final String MODEL_XMI = "component.xml";
    private static final String MODEL_PKG_NAME = "PartitionTest";
    private static final String PKG_ELEMENT = "Test";
    private static final String PKG_NAME = "PartitionExtent-{0}";
    private static final String PARTITION_NAME = "part{0}";
    private static final String INSTANCE_NAME = "{0}-ext{1}-id{2}";
    private static final String STORAGE_FACTORY = "org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeFactory";
    private static final String SERVICE_NAME = "service";
    private static final String COMPONENT_NAME = "component";
    private static final int PART_COUNT = 2;
    private static final int INSTANCE_COUNT = 100;
    
    /** Creates a new instance of FederationTest */
    public FederationTest(String testName) {
        super(testName);
    }
    
    public void test() {
        // Init
        this.init(MODEL_XMI, MODEL_PKG_NAME);
        if (!(this.repository instanceof NBMDRepositoryImpl)) {
            fail("Not a NBMDRepositoryImpl instance");
        }
        // 1st stage of test: Mount all partitions
        String[] storageIds = new String [PART_COUNT];
        String workDir = System.getProperty("work.dir");
        for (int i=0; i < PART_COUNT; i++) {
            Properties params = new Properties();
            params.put(org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeFactory.STORAGE_FILE_NAME, MessageFormat.format(workDir+File.separator+PARTITION_NAME, new Object[] {new Integer(i)}));
            storageIds[i] = mount(STORAGE_FACTORY, params);
        }
        // 2nd stage of test: Create extents in mounted partitions
        test.TestPackage[] pkgs = new test.TestPackage [PART_COUNT];
        for (int i=0; i< storageIds.length; i++) {
            ModelPackage pkgExtend = (ModelPackage) this.repository.getExtent(MODEL_PKG_NAME);
            RefObject pkgObj = findMofPackage(pkgExtend, PKG_ELEMENT);
            try {
                pkgs[i] = (test.TestPackage) ((NBMDRepositoryImpl)this.repository).createExtent(MessageFormat.format(PKG_NAME, new Object[] { new Integer(i)}), pkgObj, null, storageIds[i]);
            }catch (org.netbeans.api.mdr.CreationFailedException cfe) {
                fail("Creation of extent failed.");
            }
        }
        
        // 3rd stage of test: Content manipulation
        // Create & query test
        MessageFormat format = new MessageFormat(INSTANCE_NAME);
        for (int i=0; i< pkgs.length; i++) {
            for (int j=0; j< INSTANCE_COUNT; j++) {
                int instanceType = j % 2;
                String name ;
                switch (instanceType) {
                    case 0:
                        name = COMPONENT_NAME;
                        break;
                    case 1:
                        name = SERVICE_NAME;
                        break;
                    default:
                        name = null;
                }
                createInstance(pkgs[i],format.format(new Object[] { name, new Integer(i), new Integer(j)}),instanceType);
            }
            
            Collection c = pkgs[i].getComponent().refAllOfClass();
            if (c.size() != (INSTANCE_COUNT / 2)) {
                fail(MessageFormat.format("Extent no: {0} : invalid component instance count",
                new Object[] { new Integer(i)}));
            }
            for (Iterator it = c.iterator(); it.hasNext(); ) {
                test.Component ci = (test.Component) it.next();
                try {
                    Object[] elements = format.parse(ci.getName());
                    if (!elements[0].equals(COMPONENT_NAME))
                        fail("Invalid name");
                } catch (java.text.ParseException pe) {
                    fail("Invalid name");
                }
                
            }
            
            c = pkgs[i].getService().refAllOfClass();
            if (((INSTANCE_COUNT % 2) == 0 && c.size()!=(INSTANCE_COUNT/2))
            || ((INSTANCE_COUNT % 2) == 1 && c.size()!=(INSTANCE_COUNT/2 + 1))) {
                fail(MessageFormat.format("Extent no: {0} : invalid service instance count",
                new Object[] { new Integer(i)}));
            }
            for (Iterator it = c.iterator(); it.hasNext();) {
                test.Service si = (test.Service) it.next();
                try {
                    Object[] elements = format.parse(si.getName());
                    if (!elements[0].equals(SERVICE_NAME))
                        fail("Invalid name");
                }catch (java.text.ParseException pe) {
                    fail("Invalid name");
                }
            }
        }
        
        // Delete & query test
        if (INSTANCE_COUNT >= 4) {
            for (int i=0; i< pkgs.length; i++) {
                Collection services = pkgs[i].getService().refAllOfClass();
                Collection components = pkgs[i].getComponent().refAllOfClass();
                int oldSCount = services.size();
                int oldCCount = components.size();
                Iterator it = services.iterator();
                test.Service si = (test.Service) it.next();
                it = components.iterator();
                test.Component ci = (test.Component) it.next();
                si.refDelete();
                ci.refDelete();
                services = pkgs[i].getService().refAllOfClass();
                components = pkgs[i].getComponent().refAllOfClass();
                if (services.size() != (oldSCount-1)) {
                    fail(MessageFormat.format("Extent no: {0} : invalid service post delete count",
                    new Object[] { new Integer(i)} ));
                }
                for (Iterator sit = services.iterator(); sit.hasNext();) {
                    sit.next();
                }
                if (components.size() != (oldCCount-1)) {
                    fail(MessageFormat.format("Extent no: {0} : invalid component post delete count",
                    new Object[] { new Integer(i)} ));
                }
                for (Iterator cit = components.iterator(); cit.hasNext();) {
                    cit.next();
                }
            }
        }
        else {
            System.out.println("Skipping delete test");
        }
        
        // Attribute test
        if (INSTANCE_COUNT >= 6) {
            for (int i=0; i< pkgs.length; i++) {
                test.Component comp = null;
                test.Service serv = null;
                
                Collection c = pkgs[i].getComponent().refAllOfClass();
                for (Iterator it = c.iterator(); it.hasNext();) {
                    test.Component ci = (test.Component) it.next();
                    if (comp == null)
                        comp = ci;
                    ci.getName();
                    if (ci.getVersion() != 1) {
                        fail("Invalid value of argument");
                    }
                }
                
                c = pkgs[i].getService().refAllOfClass();
                for (Iterator it = c.iterator(); it.hasNext();) {
                    test.Service si = (test.Service) it.next();
                    if (serv == null)
                        serv = si;
                    si.getName();
                }
                
                comp.setName("X");
                comp.setVersion(0);
                serv.setName("Y");
                
                comp = (test.Component) pkgs[i].getComponent().refAllOfClass().iterator().next();
                if (! comp.getName().equals("X"))
                    fail("Invalid attribute value");
                if (comp.getVersion() != 0)
                    fail("Invalid attribute value");
                
                serv = (test.Service) pkgs[i].getService().refAllOfClass().iterator().next();
                if (!serv.getName().equals("Y"))
                    fail("Invalid attribute value");
            }
        }
        else {
            System.out.println("Skipping attribute test");
        }
        
        //4th: Association test
        if (PART_COUNT >= 2) {
            test.ServiceClass sc = pkgs[0].getService();
            test.ComponentClass cc = pkgs[1].getComponent();
            test.Service serv = sc.createService("AssociationTestService");
            test.Component comp = cc.createComponent("AssociationTestComponen",1);
            comp.getProvidedService().add(serv);
            Collection c = comp.getProvidedService();
            if (c.size() != 1)
                fail("Cross-extent association failed (size): C->S");
            test.Service stmp = (test.Service) c.iterator().next();
            if (!stmp.refMofId().equals(serv.refMofId()))
                fail("Cross-extent association failed (wrong end): C->S");
            System.out.println("C->S:"+comp.getName()+"->"+stmp.getName());
            c = serv.getProvider();
            if (c.size() != 1)
                fail("Cross-extent association failed (size): S->C");
            test.Component ctemp = (test.Component) c.iterator().next();
            if (!ctemp.refMofId().equals(comp.refMofId()))
                fail("Cross-extent association failed (wrong end): S->C");
            System.out.println("S->C:"+serv.getName()+"->"+ctemp.getName());
            test.Provides pa = pkgs[0].getProvides();
            testAssociation (pa, comp, serv);
            pa = pkgs[1].getProvides();
            testAssociation (pa, comp, serv);
            pa.remove (serv, comp);
            if (serv.getProvider().size() != 0)
                fail ("Cross-extent association failed (size): S->C");
            if (comp.getProvidedService().size() != 0)
                fail ("Cross-extent association failed (size): C->S");
            pa.add (serv, comp);
            testAssociation (pa, comp, serv);
            pa = pkgs[0].getProvides();
            testAssociation (pa, comp, serv);
        }
        else {
            System.out.println("Skipping cross extent association test");
        }
        
        int extentCount = repository.getExtentNames().length;
        // 5th stage of test: Unmount partitions
        for (int i=0; i < PART_COUNT; i++)
            unmount(storageIds[i]);
        if (extentCount != (repository.getExtentNames().length + PART_COUNT))
            fail("Invalid number of extents after unmount");
        
        //6th stage of test: Remount partitions
        extentCount = repository.getExtentNames().length;
        for (int i=0; i< PART_COUNT; i++) {
            Properties params = new Properties();
            params.put(org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeFactory.STORAGE_FILE_NAME, MessageFormat.format(workDir+File.separator+PARTITION_NAME, new Object[] {new Integer(i)}));
            storageIds[i] = mount(STORAGE_FACTORY, params);
        }
        if (extentCount != (repository.getExtentNames().length - PART_COUNT))
            fail("Invalid number of extents after remount");
        
        for (int i=0; i < PART_COUNT; i++) {
            test.TestPackage pkg = (test.TestPackage) repository.getExtent(MessageFormat.format(PKG_NAME, new Object[] { new Integer(i)}));
            Collection c = pkg.getService().refAllOfClass();
            for (Iterator it = c.iterator(); it.hasNext();) {
                test.Service si = (test.Service) it.next();
                si.getName();
            }
            c = pkg.getComponent().refAllOfClass();
            for (Iterator it = c.iterator(); it.hasNext();) {
                test.Component ci = (test.Component) it.next();
                ci.getName();
                ci.getVersion();
            }
        }
    }
    
    private void init(String xmiName, String pkg) {
        this.loadMOFModel(xmiName, pkg);
    }
    
    
    private void testAssociation(test.Provides pa, test.Component comp, test.Service serv) {
        if (! pa.exists(serv,comp))
            fail("Cross-extent association failed: exists");
        
        if (!((RefObject)pa.getProvidedService(comp).iterator().next()).refMofId().equals(serv.refMofId()))
            fail("Cross-extent association failed: getProvidedService");
        
        if (!((RefObject)pa.getProvider(serv).iterator().next()).refMofId().equals(comp.refMofId()))
            fail("Cross-extent association failed: getProvider");
    }
    
    
    private RefObject createInstance(test.TestPackage pkg, String name, int instanceType) {
        switch (instanceType) {
            case 0:
                return pkg.getComponent().createComponent(name,1);
            case 1:
                return pkg.getService().createService(name);
            default:
                return null;
        }
        
    }
    
    private String mount(String factoryClass, Properties params) {
        try {
            return ((NBMDRepositoryImpl)this.repository).mountStorage(factoryClass, params);
        }catch (org.netbeans.mdr.util.MountFailedException mfe) {
            fail ("Mount failed: " + mfe.getRootCase());
	    return null;
        }
    }
    
    private void unmount(String storageId) {
        ((NBMDRepositoryImpl)this.repository).unmountStorage(storageId);
    }
    
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(FederationTest.class);
        TestSetup setup = new TestSetup(suite) {
            public void setUp() {
            }
            
            public void tearDown() {
            }
        };
        return setup;
    }
    
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }
}
