/*
 * HandlerStorageTest.java
 *
 * Created on May 27, 2002, 5:32 PM
 */

package org.netbeans.mdr.test;

import java.io.*;
import java.util.*;
import java.net.*;
import java.text.MessageFormat;

import junit.extensions.*;
import junit.framework.*;

import org.netbeans.api.mdr.*;
import org.openide.util.Lookup;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.lib.jmi.mapping.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

/**
 *
 * @author  tz97951
 */
public class HandlerStorageTest extends MDRTestCase {
    
    private static final String MODEL_XMI = "component.xml";
    private static final String MODEL_PACKAGE = "HandlerStorageTestModel";
    private static final String PKG_ELEMENT = "Test";
    private static final String PACKAGE = "HandlerStorageTest";
    private static final String PROP_NAME ="NAME";
    private static final String PROP_VALUE = "VALUE";
    
    /** Creates a new instance of HandlerStorageTest */
    public HandlerStorageTest (String name) {
        super (name);
    }
    
    public void test () {
        try {
            this.loadMOFModel (MODEL_XMI, MODEL_PACKAGE);
            ModelPackage pkg = (ModelPackage) this.repository.getExtent (MODEL_PACKAGE);
            RefObject pkgObj = findMofPackage (pkg, PKG_ELEMENT);
            test.TestPackage tpkg = (test.TestPackage) this.repository.createExtent (PACKAGE, pkgObj, null);
            test.Component comp = tpkg.getComponent().createComponent ("TestComponent",1);
            ((org.netbeans.mdr.handlers.InstanceHandler)comp)._getDelegate().putProperty (PROP_NAME,PROP_VALUE);
            Object propValue = ((org.netbeans.mdr.handlers.InstanceHandler)comp)._getDelegate().getProperty (PROP_NAME);
            if (!PROP_VALUE.equals (propValue)) {
                fail ("Invalid property value");
            }
            ((org.netbeans.mdr.handlers.InstanceHandler)comp)._getDelegate().removeProperty (PROP_NAME);
            propValue = ((org.netbeans.mdr.handlers.InstanceHandler)comp)._getDelegate().getProperty (PROP_NAME);
            if (propValue != null) {
                fail ("Invalid property value");
            }
        }catch (org.netbeans.api.mdr.CreationFailedException cfe) {
            fail ("Extent creation failed");
        }
    }
    
    
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(HandlerStorageTest.class);
        TestSetup setup = new TestSetup(suite) {
            public void setUp() {
            }    
            public void tearDown() {
            }
        };
        return setup;
    }
    
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
}
