/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.test;

import java.io.*;
import java.util.*;
import java.net.*;

import junit.extensions.*;
import junit.framework.*;

import org.netbeans.api.mdr.*;
import org.openide.util.Lookup;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.lib.jmi.mapping.*;

import org.netbeans.api.mdr.events.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;
import javax.jmi.xmi.*;

/**
 * Abstract predecessor of MDR test cases handling set up and providing some "high level"
 * functionality over repository (e.g. load model method).
 */
public abstract class MDREventsTestCase extends TestCase /*implements MDRPreChangeListener, MDRChangeListener*/ {
    
    // "type" of event
    public static final int PLANNED = 2;
    public static final int CHANGED = 4;
    public static final int CANCELED = 8;
    
    // queue to test right order of events
    protected LinkedList eventsQueue = new LinkedList();
    
    // default repository, it is inited by setUp method
    protected MDRepository repository = null;
    // default model package (created on booting repository)
    protected ModelPackage modelPackage = null;
    
    public MDREventsTestCase(String testName) {
        super (testName);
    }
    
    /**
     * Instantiates Model package and loads MOF model to it.
     *
     * @param docName XMI file name (should reside in 'data' directory)
     * @param pkgName name of Model package extent to be instantiated
     *
     * @return instantiated model package
     */
    public ModelPackage loadMOFModel (String docName, String pkgName) {
        
        ModelPackage pkg = null;
        
        Lookup lookup = Lookup.getDefault ();
        XmiReader reader = (XmiReader) lookup.lookup (XmiReader.class);
        URL url = this.getClass ().getResource ("data" + File.separator + docName);
        if (url == null) {
            fail ("Resource not found.");
        }
        
        try {
            pkg = (ModelPackage) repository.createExtent(pkgName);
        } catch (CreationFailedException cfe) {
            fail ("Package instantiation failed: " + pkgName);
        }
        
        try {
            repository.beginTrans (true);
            reader.read (url.toExternalForm(), pkg);
        } catch (Exception e) {
            fail (e.getMessage ());
        } finally {
            repository.endTrans ();
        }
        return pkg;
        
    }
    
    public MofPackage findMofPackage (ModelPackage modelPackage, String name) {
        MofPackageClass proxy = modelPackage.getMofPackage ();
        Iterator iter = proxy.refAllOfType ().iterator ();
        MofPackage thePackage = null;
        while (iter.hasNext ()) {
            MofPackage pkg = (MofPackage) iter.next ();
            if (pkg.getName ().equals (name)) {
                thePackage = pkg;
                break;
            } // if                
        } // while
        if (thePackage == null)
            fail ("Cannot find package " + name);
        return thePackage;
    }
    
    /**
     * Creates extent according to given MofPackage and name.
     */
    public RefPackage createExtent (MofPackage pkg, String name) {
        try {
            return repository.createExtent (name, pkg);
        } catch (CreationFailedException e) {
        }
        fail ("Package instantiation failed: " + name);
        return null;
    }
        
    /**
     * Returns extent in repository given by its name.
     */
    public ModelPackage getExtent (String name) {        
        ModelPackage vmp = null;        
        try {
            vmp = (ModelPackage) repository.getExtent (name);
        } catch (Exception e) {
            fail ("Model not loaded, name not resolved.");
        }
        return vmp;        
    }
    
    public RefPackage createMOFExtent(String extentName) {
        try {
            return repository.createExtent(extentName);
        } catch (CreationFailedException cfe) {
            cfe.printStackTrace();
        }
        return null;
    }
    
    // -------------------------------------------------------------------------
    
    protected void setUp() {
        // properties will be set only if running outside of IDE
        if (System.getProperty("org.openide.version") == null) {
            System.setProperty("org.netbeans.mdr.persistence.Dir", System.getProperty("work.dir") + "/TestEventsRepository_" + System.currentTimeMillis());
            System.setProperty("org.netbeans.mdr.storagemodel.StorageFactoryClassName",
                "org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeFactory");
            System.setProperty("org.netbeans.lib.jmi.Logger.fileName", "");
        }
        
        repository = MDRManager.getDefault().getDefaultRepository();
        if (repository == null) {
            fail("Repository not found!");
        } else {
            // start up the repository
            repository.getExtentNames();
        }
        
    }        
    
    protected void tearDown() {
        
    }
    
    // -------------------------------------------------------------------------
    //   MDRChangeListener, MDRPreChangeListener
    // -------------------------------------------------------------------------
    /*
    public void change(MDRChangeEvent e) {
        assertEquals("Wrong order of events!", eventsQueue.getFirst(), e);
        eventsQueue.removeFirst();
        processEvent(e, CHANGED);
    }
    
    public void changeCancelled(MDRChangeEvent e) {
        assertEquals("Wrong order of events!", eventsQueue.getFirst(), e);
        eventsQueue.removeFirst();
        processEvent(e, CANCELED);        
    }
    
    public void plannedChange(MDRChangeEvent e) {
        eventsQueue.add(e);
        processEvent(e, PLANNED);
    }
    */
    /*
    protected void processEvent(MDRChangeEvent e, int type, int eventType) throws IOException {
        
        if (e.isOfType(InstanceEvent.EVENTMASK_INSTANCE) && (eventType == InstanceEvent.EVENTMASK_INSTANCE)) { // InstanceEvent
            
            // EVENT_INSTANCE_CREATE
            if (e.isOfType(InstanceEvent.EVENT_INSTANCE_CREATE) && (type == PLANNED)) {
                log("EVENT_INSTANCE_CREATE - PLANNED");
            } else if (e.isOfType(InstanceEvent.EVENT_INSTANCE_CREATE) && (type == CHANGED)) {
                log("EVENT_INSTANCE_CREATE - CHANGED: " + 
                    ((ModelElement) ((InstanceEvent) e).getInstance().refMetaObject()).getName());
            } else if (e.isOfType(InstanceEvent.EVENT_INSTANCE_CREATE) && (type == CANCELED)) {
                log("EVENT_INSTANCE_CREATE - CANCELED");
            } 
            // EVENT_INSTANCE_DELETE
            else if (e.isOfType(InstanceEvent.EVENT_INSTANCE_DELETE) && (type == PLANNED)) {
                log("EVENT_INSTANCE_DELETE - PLANNED: " + 
                    ((ModelElement) ((InstanceEvent) e).getInstance().refMetaObject()).getName());
            } else if (e.isOfType(InstanceEvent.EVENT_INSTANCE_DELETE) && (type == CHANGED)) {
                log("EVENT_INSTANCE_DELETE - CHANGED");
            } else if (e.isOfType(InstanceEvent.EVENT_INSTANCE_DELETE) && (type == CANCELED)) {
                log("EVENT_INSTANCE_DELETE - CANCELED: " + 
                    ((ModelElement) ((InstanceEvent) e).getInstance().refMetaObject()).getName());
            }
            
        } else if (e.isOfType(ExtentEvent.EVENTMASK_EXTENT)  && (eventType == ExtentEvent.EVENTMASK_EXTENT)) { // ExtentEvent
            
            // EVENT_EXTENT_CREATE
            if (e.isOfType(ExtentEvent.EVENT_EXTENT_CREATE) && (type == PLANNED)) {
                ref("EVENT_EXTENT_CREATE - PLANNED: " + ((ExtentEvent) e).getExtentName());
            } else if (e.isOfType(ExtentEvent.EVENT_EXTENT_CREATE) && (type == CHANGED)) {
                ref("EVENT_EXTENT_CREATE - CHANGED: " + ((ExtentEvent) e).getExtentName());
            } else if (e.isOfType(ExtentEvent.EVENT_EXTENT_CREATE) && (type == CANCELED)) {
                ref("EVENT_EXTENT_CREATE - CANCELED: " + ((ExtentEvent) e).getExtentName());
            } 
            // EVENT_EXTENT_DELETE
            else if (e.isOfType(ExtentEvent.EVENT_EXTENT_DELETE) && (type == PLANNED)) {
                log("EVENT_EXTENT_DELETE - PLANNED: " + ((ExtentEvent) e).getExtentName());
            } else if (e.isOfType(ExtentEvent.EVENT_EXTENT_DELETE) && (type == CHANGED)) {
                log("EVENT_EXTENT_DELETE - CHANGED: " + ((ExtentEvent) e).getExtentName());
            } else if (e.isOfType(ExtentEvent.EVENT_EXTENT_DELETE) && (type == CANCELED)) {
                log("EVENT_EXTENT_DELETE - CANCELED: " + ((ExtentEvent) e).getExtentName());
            }
            
        } else if ((e.isOfType(AttributeEvent.EVENTMASK_ATTRIBUTE) || // AttributeEvent
                    e.isOfType(AttributeEvent.EVENTMASK_CLASSATTR)) &&
                    
                   ((eventType == AttributeEvent.EVENTMASK_ATTRIBUTE) || 
                    (eventType == AttributeEvent.EVENTMASK_CLASSATTR))) {
            
            // EVENT_ATTRIBUTE_ADD
            if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_ADD) && (type == PLANNED)) {
                log("EVENT_ATTRIBUTE_ADD - PLANNED");
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_ADD) && (type == CHANGED)) {
                log("EVENT_ATTRIBUTE_ADD - CHANGED: " + ((AttributeEvent) e).getAttributeName());
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_ADD) && (type == CANCELED)) {
                log("EVENT_ATTRIBUTE_ADD - CANCELED");                
            } 
            // EVENT_ATTRIBUTE_SET
            else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_SET) && (type == PLANNED)) {
                log("EVENT_ATTRIBUTE_SET - PLANNED");
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_SET) && (type == CHANGED)) {
                log("EVENT_ATTRIBUTE_SET - CHANGED: " + ((AttributeEvent) e).getAttributeName());
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_SET) && (type == CANCELED)) {
                log("EVENT_ATTRIBUTE_SET - CANCELED");
            } 
            // EVENT_ATTRIBUTE_REMOVE
            else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_REMOVE) && (type == PLANNED)) {
                log("EVENT_ATTRIBUTE_REMOVE - PLANNED: " + ((AttributeEvent) e).getAttributeName());
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_REMOVE) && (type == CHANGED)) {
                log("EVENT_ATTRIBUTE_REMOVE - CHANGED");
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_REMOVE) && (type == CANCELED)) {
                log("EVENT_ATTRIBUTE_REMOVE - CANCELED");
            }
                       
        } else if (e.isOfType(AssociationEvent.EVENTMASK_ASSOCIATION) && (eventType == AssociationEvent.EVENTMASK_ASSOCIATION)) { // AssociationEvent                        
            
            // EVENT_ASSOCIATION_ADD
            if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_ADD) && (type == PLANNED)) {
                log("EVENT_ASSOCIATION_ADD - PLANNED");
            } else if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_ADD) && (type == CHANGED)) {
                log("EVENT_ASSOCIATION_ADD - CHANGED: " + ((AssociationEvent) e).getEndName());
            } else if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_ADD) && (type == CANCELED)) {
                log("EVENT_ASSOCIATION_ADD - CANCELED");
            } 
            // EVENT_ASSOCIATION_SET
            else if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_SET) && (type == PLANNED)) {
                log("EVENT_ASSOCIATION_SET - PLANNED");
            } else if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_SET) && (type == CHANGED)) {
                log("EVENT_ASSOCIATION_SET - CHANGED: " + ((AssociationEvent) e).getEndName());
            } else if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_SET) && (type == CANCELED)) {
                log("EVENT_ASSOCIATION_SET - CANCELED");
            }
            // EVENT_ASSOCIATION_REMOVE
            else if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_REMOVE) && (type == PLANNED)) {
                log("EVENT_ASSOCIATION_REMOVE - PLANNED: " + ((AssociationEvent) e).getEndName());
            } else if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_REMOVE) && (type == CHANGED)) {
                log("EVENT_ASSOCIATION_REMOVE - CHANGED");
            } else if (e.isOfType(AssociationEvent.EVENT_ASSOCIATION_REMOVE) && (type == CANCELED)) {
                log("EVENT_ASSOCIATION_REMOVE - CANCELED");
            }
            
        }
        
    }*/
    
    protected void log(String message) {
        getLog().println(message);
    }
    
    protected PrintStream getLog() {
        return System.err;
    }
}
