/*
 * TestListeners.java
 * NetBeans JUnit based test
 *
 * Created on 5. duben 2002, 17:00
 */

package org.netbeans.mdr.test;

import java.util.Iterator;
import java.util.Collection;

import junit.framework.*;

import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.NBMDRepositoryImpl;

import org.netbeans.api.mdr.MDRManager;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.CreationFailedException;

import org.netbeans.api.mdr.events.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

/**
 *
 * @author mk97936
 */
public class MDRTestAttributePreEvents extends MDREventsTestCase implements MDRPreChangeListener {
    
    private static final String PKG_NAME = "TEST_MOF";
    
    private EventsList eventsList = new EventsList();
    
    public MDRTestAttributePreEvents(java.lang.String testName) {
        super(testName);
    }
    
    protected void setUp() {
        super.setUp();
        ((MDRChangeSource) repository).addListener(this);
    }
    
    protected void tearDown() {
        super.tearDown();
        ((MDRChangeSource) repository).removeListener(this);
    }
    
    // -------------------------------------------------------------------------
    
    public void testSetAttribute() {
        
        RefPackage testMOFPackage = createMOFExtent(PKG_NAME);
        
        EventsDataGenerator generator = new EventsDataGenerator(repository.getExtent(PKG_NAME));
        
        RefObject newRefObj = null;
        Collection allMOFClasses = testMOFPackage.refAllClasses();
        Iterator iterClasses = allMOFClasses.iterator();
        while (iterClasses.hasNext()) {
            RefClass clsProxy = (RefClass) iterClasses.next();
            MofClass metaClass = (MofClass) clsProxy.refMetaObject();
            if (!metaClass.isAbstract()) {
                log("Creating instance for class: " + metaClass.getName());
                newRefObj = generator.generateInstance(metaClass);
                eventsList.addPattern2(metaClass.getName(), EventsList._PLANNED | EventsList._SET | EventsList._CHANGED, System.currentTimeMillis());
                boolean ws = generator.setAttribute(newRefObj, null, true);
                // !@#$%^& wait until event arives
                for (int i = 0; i < 20; i++) {
                    try { Thread.currentThread().sleep(100); }
                        catch (InterruptedException ie) { }
                }
                if (ws) {
                    assertTrue(eventsList.checkEvents(metaClass.getName(), EventsList._PLANNED | EventsList._SET | EventsList._CHANGED));
                }
                eventsList.clear();
            } else {
                log("Abstract class: " + metaClass.getName());
            }
        }
        
    }
    
    public void testSetAttributeCL() {
        
        RefPackage testMOFPackage = createMOFExtent(PKG_NAME);
        
        EventsDataGenerator generator = new EventsDataGenerator(repository.getExtent(PKG_NAME));
                
        MDRAttributePreListener listener = new MDRAttributePreListener("test");
        listener.setRef(eventsList);                
        
        RefObject newRefObj = null;
        Collection allMOFClasses = testMOFPackage.refAllClasses();
        Iterator iterClasses = allMOFClasses.iterator();        
        while (iterClasses.hasNext()) {
            RefClass clsProxy = (RefClass) iterClasses.next();
            MofClass metaClass = (MofClass) clsProxy.refMetaObject();
            if (!metaClass.isAbstract()) {
                log("Creating instance for class: " + metaClass.getName());
                newRefObj = generator.generateInstance(metaClass);
                // listening on class instance and repository too
                ((MDRChangeSource) newRefObj).addListener(listener);
                eventsList.addPattern2(metaClass.getName(), EventsList._PLANNED | EventsList._SET | EventsList._CHANGED, System.currentTimeMillis());
                boolean ws = generator.setAttribute(newRefObj, null, true);
                // !@#$%^& wait until event arives
                for (int i = 0; i < 20; i++) {
                    try { Thread.currentThread().sleep(100); }
                        catch (InterruptedException ie) { }
                }
                if (ws) {
                    assertTrue(eventsList.checkEvents(metaClass.getName(), EventsList._PLANNED | EventsList._SET | EventsList._CHANGED));
                }
                eventsList.clear();
            } else {
                log("Abstract class: " + metaClass.getName());
            }
        }
        
    }
    
    public void testAddRemoveAttribute() {
        
        RefPackage testMOFPackage = createMOFExtent(PKG_NAME);
        
        EventsDataGenerator generator = new EventsDataGenerator(repository.getExtent(PKG_NAME));
        
        RefObject newRefObj = null;
        Collection allMOFClasses = testMOFPackage.refAllClasses();
        Iterator iterClasses = allMOFClasses.iterator();
        while (iterClasses.hasNext()) {
            RefClass clsProxy = (RefClass) iterClasses.next();
            MofClass metaClass = (MofClass) clsProxy.refMetaObject();
            if (!metaClass.isAbstract()) {
                log("Creating instance for class: " + metaClass.getName());
                newRefObj = generator.generateInstance(metaClass);
                eventsList.addPattern2(metaClass.getName(), EventsList._PLANNED | EventsList._ADD | EventsList._CHANGED, System.currentTimeMillis());
                eventsList.addPattern2(metaClass.getName(), EventsList._PLANNED | EventsList._REMOVE | EventsList._CHANGED, System.currentTimeMillis());
                boolean ws = generator.addAttribute(newRefObj, true, null, true);
                // !@#$%^& wait until event arives
                for (int i = 0; i < 20; i++) {
                    try { Thread.currentThread().sleep(100); }
                        catch (InterruptedException ie) { }
                }
                if (ws) {
                    assertTrue(eventsList.checkEvents(metaClass.getName(), EventsList._PLANNED | EventsList._ADD | EventsList._CHANGED));
                    assertTrue(eventsList.checkEvents(metaClass.getName(), EventsList._PLANNED | EventsList._REMOVE | EventsList._CHANGED));
                }
                eventsList.clear();
            } else {
                log("Abstract class: " + metaClass.getName());
            }
        }
        
    }
    
    public void testAddRemoveAttributeCL() {
        
        RefPackage testMOFPackage = createMOFExtent(PKG_NAME);
        
        EventsDataGenerator generator = new EventsDataGenerator(repository.getExtent(PKG_NAME));
        
        MDRAttributePreListener listener = new MDRAttributePreListener("test");
        listener.setRef(eventsList);
        
        RefObject newRefObj = null;
        Collection allMOFClasses = testMOFPackage.refAllClasses();
        Iterator iterClasses = allMOFClasses.iterator();
        while (iterClasses.hasNext()) {
            RefClass clsProxy = (RefClass) iterClasses.next();
            MofClass metaClass = (MofClass) clsProxy.refMetaObject();
            if (!metaClass.isAbstract()) {
                log("Creating instance for class: " + metaClass.getName());
                newRefObj = generator.generateInstance(metaClass);
                ((MDRChangeSource) newRefObj).addListener(listener);
                eventsList.addPattern2(metaClass.getName(), EventsList._PLANNED | EventsList._ADD | EventsList._CHANGED, System.currentTimeMillis());
                eventsList.addPattern2(metaClass.getName(), EventsList._PLANNED | EventsList._REMOVE | EventsList._CHANGED, System.currentTimeMillis());
                boolean ws = generator.addAttribute(newRefObj, true, null, true);
                // !@#$%^& wait until event arives
                for (int i = 0; i < 20; i++) {
                    try { Thread.currentThread().sleep(100); }
                        catch (InterruptedException ie) { }
                }
                if (ws) {
                    assertTrue(eventsList.checkEvents(metaClass.getName(), EventsList._PLANNED | EventsList._ADD | EventsList._CHANGED));
                    assertTrue(eventsList.checkEvents(metaClass.getName(), EventsList._PLANNED | EventsList._REMOVE | EventsList._CHANGED));
                }
                eventsList.clear();
            } else {
                log("Abstract class: " + metaClass.getName());
            }
        }

    }
    
    // -------------------------------------------------------------------------
    
    public void change(MDRChangeEvent e) {
        assertEquals("Wrong order of events!", eventsQueue.getFirst(), e);
        eventsQueue.removeFirst();
        processEvent(e, CHANGED);
    }
    
    public void changeCancelled(MDRChangeEvent e) {
        assertEquals("Wrong order of events!", eventsQueue.getFirst(), e);
        eventsQueue.removeFirst();
        processEvent(e, CANCELED);
    }
    
    public void plannedChange(MDRChangeEvent e) {
        eventsQueue.add(e);
        processEvent(e, PLANNED);
    }
    
    private void processEvent(MDRChangeEvent e, int type) {
        
        if (e.isOfType(AttributeEvent.EVENTMASK_ATTRIBUTE) || // AttributeEvent
        e.isOfType(AttributeEvent.EVENTMASK_CLASSATTR)) {
            
            // EVENT_ATTRIBUTE_ADD
            if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_ADD) && (type == PLANNED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._ADD | EventsList._PLANNED);
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_ADD) && (type == CHANGED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._ADD | EventsList._CHANGED);
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_ADD) && (type == CANCELED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._ADD | EventsList._CANCELED);
            }
            // EVENT_ATTRIBUTE_SET
            else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_SET) && (type == PLANNED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._SET | EventsList._PLANNED);
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_SET) && (type == CHANGED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._SET | EventsList._CHANGED);
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_SET) && (type == CANCELED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._SET | EventsList._CANCELED);
            }
            // EVENT_ATTRIBUTE_REMOVE
            else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_REMOVE) && (type == PLANNED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._REMOVE | EventsList._PLANNED);
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_REMOVE) && (type == CHANGED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._REMOVE | EventsList._CHANGED);
            } else if (e.isOfType(AttributeEvent.EVENT_ATTRIBUTE_REMOVE) && (type == CANCELED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((AttributeEvent) e).getSource()).refMetaObject()).getName(),
                                    e, System.currentTimeMillis(), EventsList._REMOVE | EventsList._CANCELED);
            }
            
        }
        
    }
    
}
