/*
 * TestListeners.java
 * NetBeans JUnit based test
 *
 * Created on 5. duben 2002, 17:00
 */

package org.netbeans.mdr.test;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.*;

import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.NBMDRepositoryImpl;

import org.netbeans.api.mdr.MDRManager;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.CreationFailedException;

import org.netbeans.api.mdr.events.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

/**
 *
 * @author mk97936
 */
public class MDRTestExtentEvents extends MDREventsTestCase implements MDRChangeListener {
    
    private static final String PKG_NAME_MOF = "MOF_EXTENT";
    private static final String PKG_NAME_JAVA = "JAVA_EXTENT";
    private static final String MDL_NAME_JAVA = "JAVA_MODEL";
    private static final String PKG_NAME_TEXT = "TEXT_EXTENT";
    private static final String MDL_NAME_TEXT = "TEXT_MODEL";
    
    private java.io.PrintStream goldenRef = null;
    private EventsList eventsList = new EventsList();
    
    public MDRTestExtentEvents(java.lang.String testName) {
        super(testName);
    }
    
    protected void setUp() {
        super.setUp();
        ((MDRChangeSource) repository).addListener(this);
    }
    
    protected void tearDown() {
        super.tearDown();
        ((MDRChangeSource) repository).removeListener(this);
    }
    
    // -------------------------------------------------------------------------
    
    // Instantiate MOF
    public void testCreateMOFExtent() {
        
        RefPackage mofExtent = null;
        try {
            eventsList.addPattern2(PKG_NAME_MOF, EventsList._CREATE & EventsList._CHANGED, System.currentTimeMillis());
            mofExtent = repository.createExtent(PKG_NAME_MOF);
            for (int i = 0; i < 10; i++) {
                try { Thread.currentThread().sleep(100); }
                   catch (InterruptedException ie) { }
            }
            assertTrue(eventsList.checkEvents(PKG_NAME_MOF, EventsList._CREATE | EventsList._CHANGED));
            eventsList.clear();
        } catch (CreationFailedException cfe) {
            fail(cfe.toString());
        }
        
    }
    
    // Load Java model and instantiate it
    public void testCreateJavaExtent() {
        
        RefPackage javaExtent = null;
        
        eventsList.addPattern2(MDL_NAME_JAVA, EventsList._CREATE & EventsList._CHANGED, System.currentTimeMillis());
        ModelPackage javaMOFModel = loadMOFModel("Java.xml", MDL_NAME_JAVA);
        assertTrue(eventsList.checkEvents(MDL_NAME_JAVA, EventsList._CREATE | EventsList._CHANGED));
        eventsList.clear();
        try {
            eventsList.addPattern2(PKG_NAME_JAVA, EventsList._CREATE & EventsList._CHANGED, System.currentTimeMillis());
            javaExtent = repository.createExtent(PKG_NAME_JAVA, findMofPackage(javaMOFModel, "Core"));
            for (int i = 0; i < 10; i++) {
                try { Thread.currentThread().sleep(100); } 
                    catch (InterruptedException ie) { }
            }
            assertTrue(eventsList.checkEvents(PKG_NAME_JAVA, EventsList._CREATE | EventsList._CHANGED));
            eventsList.clear();
        } catch (CreationFailedException cfe) {
            fail(cfe.toString());
        }
        
    }
    
    public void testDeleteMOFExtent() {
        
        RefPackage mofExtent = repository.getExtent(PKG_NAME_MOF);
        eventsList.addPattern2(PKG_NAME_MOF, EventsList._DELETE & EventsList._CHANGED, System.currentTimeMillis());
        mofExtent.refDelete();
        for (int i = 0; i < 10; i++) {
            try { Thread.currentThread().sleep(100); } 
                catch (InterruptedException ie) { }
        }
        assertTrue(eventsList.checkEvents(PKG_NAME_MOF, EventsList._DELETE | EventsList._CHANGED));
        eventsList.clear();
        
    }
    
    public void testDeleteJavaExtent() {
        
        RefPackage javaExtent = repository.getExtent(PKG_NAME_JAVA);
        eventsList.addPattern2(PKG_NAME_JAVA, EventsList._DELETE & EventsList._CHANGED, System.currentTimeMillis());
        javaExtent.refDelete();
        for (int i = 0; i < 10; i++) {
            try { Thread.currentThread().sleep(100); } 
                catch (InterruptedException ie) { }
        }
        assertTrue(eventsList.checkEvents(PKG_NAME_JAVA, EventsList._DELETE | EventsList._CHANGED));
        eventsList.clear();        
        
    }
    
    // -------------------------------------------------------------------------
    
    public void change(MDRChangeEvent e) {
        processEvent(e, CHANGED);
    }
    
    private void processEvent(MDRChangeEvent e, int type) {
        
        if (e.isOfType(ExtentEvent.EVENTMASK_EXTENT)) { // ExtentEvent
            
            // EVENT_EXTENT_CREATE
            if (e.isOfType(ExtentEvent.EVENT_EXTENT_CREATE) && (type == PLANNED)) {
                eventsList.addEvent(((ExtentEvent) e).getExtentName(), e, System.currentTimeMillis(),
                                    EventsList._CREATE | EventsList._PLANNED);
            } else if (e.isOfType(ExtentEvent.EVENT_EXTENT_CREATE) && (type == CHANGED)) {
                eventsList.addEvent(((ExtentEvent) e).getExtentName(), e, System.currentTimeMillis(),
                                    EventsList._CREATE | EventsList._CHANGED);
            } else if (e.isOfType(ExtentEvent.EVENT_EXTENT_CREATE) && (type == CANCELED)) {
                eventsList.addEvent(((ExtentEvent) e).getExtentName(), e, System.currentTimeMillis(),
                                    EventsList._CREATE | EventsList._CANCELED);
            }
            // EVENT_EXTENT_DELETE
            else if (e.isOfType(ExtentEvent.EVENT_EXTENT_DELETE) && (type == PLANNED)) {
                eventsList.addEvent(((ExtentEvent) e).getExtentName(), e, System.currentTimeMillis(),
                                    EventsList._DELETE | EventsList._PLANNED);
            } else if (e.isOfType(ExtentEvent.EVENT_EXTENT_DELETE) && (type == CHANGED)) {
                eventsList.addEvent(((ExtentEvent) e).getExtentName(), e, System.currentTimeMillis(),
                                    EventsList._DELETE | EventsList._CHANGED);
            } else if (e.isOfType(ExtentEvent.EVENT_EXTENT_DELETE) && (type == CANCELED)) {
                eventsList.addEvent(((ExtentEvent) e).getExtentName(), e, System.currentTimeMillis(),
                                    EventsList._DELETE | EventsList._CANCELED);
            }
            
        }
    }
    
}
