/*
 * TestListeners.java
 * NetBeans JUnit based test
 *
 * Created on 5. duben 2002, 17:00
 */

package org.netbeans.mdr.test;

import java.util.Iterator;
import java.util.Collection;

import junit.framework.*;

import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.NBMDRepositoryImpl;

import org.netbeans.api.mdr.MDRManager;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.CreationFailedException;

import org.netbeans.api.mdr.events.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

/**
 *
 * @author mk97936
 */
public class MDRTestInstanceEvents extends MDREventsTestCase implements MDRChangeListener {
    
    private static final String PKG_NAME = "TEST_MOF";
    
    private EventsList eventsList = new EventsList();
    
    public MDRTestInstanceEvents(java.lang.String testName) {
        super(testName);
    }
    
    protected void setUp() {
        super.setUp();
        ((MDRChangeSource) repository).addListener(this);
    }
    
    protected void tearDown() {
        super.tearDown();
        ((MDRChangeSource) repository).removeListener(this);
        
    }
    
    // -------------------------------------------------------------------------
    
    public void testCreateInstance() {
        
        RefPackage testMOFPackage = createMOFExtent(PKG_NAME);
        
        EventsDataGenerator generator = new EventsDataGenerator(repository.getExtent(PKG_NAME));
        
        RefObject newRefObj = null;
        Collection allMOFClasses = testMOFPackage.refAllClasses();
        Iterator iterClasses = allMOFClasses.iterator();
        while (iterClasses.hasNext()) {
            RefClass clsProxy = (RefClass) iterClasses.next();
            MofClass metaClass = (MofClass) clsProxy.refMetaObject();
            if (!metaClass.isAbstract()) {
                log("Creating instance for class: " + metaClass.getName());
                eventsList.addPattern2(metaClass.getName(), EventsList._CREATE | EventsList._CHANGED, System.currentTimeMillis());
                newRefObj = generator.generateInstance(metaClass);
                // !@#$%^& wait until event arives
                for (int i = 0; i < 20; i++) {
                    try { Thread.currentThread().sleep(100); }
                        catch (InterruptedException ie) { }
                }
                assertTrue(eventsList.checkEvents(metaClass.getName(), EventsList._CREATE | EventsList._CHANGED));
                eventsList.clear();
            } else {
                log("Abstract class: " + metaClass.getName());
            }
        }
        
    }
    
    public void testDeleteInstance() {
        
        RefPackage testMOFPackage = createMOFExtent(PKG_NAME);
        
        EventsDataGenerator generator = new EventsDataGenerator(repository.getExtent(PKG_NAME));
        
        RefObject newRefObj = null;
        Collection allMOFClasses = testMOFPackage.refAllClasses();
        Iterator iterClasses = allMOFClasses.iterator();
        while (iterClasses.hasNext()) {
            RefClass clsProxy = (RefClass) iterClasses.next();
            MofClass metaClass = (MofClass) clsProxy.refMetaObject();
            if (!metaClass.isAbstract()) {
                log("Creating instance for class: " + metaClass.getName());
                eventsList.addPattern2(metaClass.getName(), EventsList._CREATE | EventsList._CHANGED, System.currentTimeMillis());
                newRefObj = generator.generateInstance(metaClass);
                // !@#$%^& wait until event arives
                for (int i = 0; i < 20; i++) {
                    try { Thread.currentThread().sleep(100); }
                        catch (InterruptedException ie) { }
                }
                assertTrue(eventsList.checkEvents(metaClass.getName(), EventsList._CREATE | EventsList._CHANGED));
                eventsList.clear();

                log("Deleting instance of class: " + metaClass.getName());
                eventsList.addPattern2("DELETE", EventsList._DELETE | EventsList._CHANGED, System.currentTimeMillis());
                newRefObj.refDelete();
                // !@#$%^& wait until event arives
                for (int i = 0; i < 20; i++) {
                    try { Thread.currentThread().sleep(100); }
                        catch (InterruptedException ie) { }
                }
                assertTrue(eventsList.checkEvents("DELETE", EventsList._DELETE | EventsList._CHANGED));
                eventsList.clear();
            } else {
                log("Abstract class: " + metaClass.getName());
            }
        }
        
    }
    
    // -------------------------------------------------------------------------
    
    public void change(MDRChangeEvent e) {
        processEvent(e, CHANGED);
    }
    
    private void processEvent(MDRChangeEvent e, int type) {
        
        if (e.isOfType(InstanceEvent.EVENTMASK_INSTANCE)) { // InstanceEvent
            
            // EVENT_INSTANCE_CREATE
            if (e.isOfType(InstanceEvent.EVENT_INSTANCE_CREATE) && (type == PLANNED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((InstanceEvent) e).getSource()).refMetaObject()).getName(), 
                                    e, System.currentTimeMillis(), EventsList._CREATE | EventsList._PLANNED);
            } else if (e.isOfType(InstanceEvent.EVENT_INSTANCE_CREATE) && (type == CHANGED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((InstanceEvent) e).getSource()).refMetaObject()).getName(), 
                                    e, System.currentTimeMillis(), EventsList._CREATE | EventsList._CHANGED);
            } else if (e.isOfType(InstanceEvent.EVENT_INSTANCE_CREATE) && (type == CANCELED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((InstanceEvent) e).getSource()).refMetaObject()).getName(), 
                                    e, System.currentTimeMillis(), EventsList._CREATE | EventsList._CANCELED);
            }
            // EVENT_INSTANCE_DELETE
            else if (e.isOfType(InstanceEvent.EVENT_INSTANCE_DELETE) && (type == PLANNED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((InstanceEvent) e).getSource()).refMetaObject()).getName(), 
                                    e, System.currentTimeMillis(), EventsList._DELETE | EventsList._PLANNED);
            } else if (e.isOfType(InstanceEvent.EVENT_INSTANCE_DELETE) && (type == CHANGED)) {
                eventsList.addEvent("DELETE", e, System.currentTimeMillis(), EventsList._DELETE | EventsList._CHANGED);
            } else if (e.isOfType(InstanceEvent.EVENT_INSTANCE_DELETE) && (type == CANCELED)) {
                eventsList.addEvent(((ModelElement) ((RefBaseObject)((InstanceEvent) e).getSource()).refMetaObject()).getName(), 
                                    e, System.currentTimeMillis(), EventsList._DELETE | EventsList._CANCELED);
            }
            
        }
        
    }
    
}
