/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.test;

import java.io.*;
import java.util.*;
import java.net.*;

import junit.extensions.*;
import junit.framework.*;

import org.netbeans.api.mdr.*;
import org.openide.util.Lookup;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.lib.jmi.mapping.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

/**
 * Multivalued index test case.
 */
public class MultiAttrTest extends MDRTestCase {

    public MultiAttrTest(String testName) {
        super (testName);
    }
    
    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite ());
    }
    
    public static Test suite () {
        TestSuite suite = new TestSuite ();
        suite.addTestSuite (MultiAttrTest.class);
        
        TestSetup setup = new TestSetup (suite) {
            public void setUp () {
            }
            public void tearDown () {
            }
        };
        return setup;
    }
    
    public void test() {
        ModelPackage modelPackage = loadMOFModel ("MultiAttrModel.xml", "model");
        RefPackage pkg = createExtent (findMofPackage (modelPackage, "MultiAttrModel"), "MultiAttrModel");
        
        RefClass refClass = pkg.refClass("Word");
        List params = new LinkedList();
        params.add(new LinkedList());
        RefObject obj = refClass.refCreateInstance(params);
        List attr = (List) obj.refGetValue("name");
        
        try {
            repository.beginTrans (true);
            attr.add ("a");
            attr.add ("b");            
        } finally {
            repository.endTrans (true);
        }
        List attr2 = (List) obj.refGetValue("name");
        if (attr.size() != attr2.size()) {
            fail();
        }
    }

}
