/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.test;

import java.io.*;
import java.util.*;
import java.net.*;

import junit.extensions.*;
import junit.framework.*;

import org.netbeans.api.mdr.*;
import org.openide.util.Lookup;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.lib.jmi.mapping.*;

import org.xml.sax.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

/**
 * Test case verifying functionality of package instantiation, especially cases when a package
 * is a subclass of another package.
 */
public class PackageInheritanceTest extends MDRTestCase {
    
    public PackageInheritanceTest(String testName) {
        super (testName);
    }
    
    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite ());
    }
    
    public static Test suite () {
        TestSuite suite = new TestSuite ();
        suite.addTestSuite (PackageInheritanceTest.class);
        
        TestSetup setup = new TestSetup (suite) {
            public void setUp () {
//                org.netbeans.mdr.handlers.BaseObjectHandler.setDefaultClassLoader (this.getClass ().getClassLoader ());
            }
            public void tearDown () {
            }
        };        
        return setup;        
    }

    public void test () {
        ModelPackage pkg = loadMOFModel ("pkg_inher.xml", "PureMOF");
        MofPackage mofPkg = findMofPackage (pkg, "Package_1");
        RefPackage pkg_1 = createExtent (mofPkg, "Package_1");
        mofPkg = findMofPackage (pkg, "Package_2");
        RefPackage pkg_2 = createExtent (mofPkg, "Package_2");
        mofPkg = findMofPackage (pkg, "Package_3");
        RefPackage pkg_3 = createExtent (mofPkg, "Package_3");
        
        try {
            for (char x = 'A'; x <= 'E'; x++)
                pkg_3.refClass ("Class_" + x);            
            for (char x = 'A'; x <= 'D'; x++)
                pkg_2.refClass ("Class_" + x);
            
            new RandomDataGenerator ().generate (pkg_3, 0, 5);
            new RandomDataGenerator ().generate (pkg_2, 0, 5);
            new RandomDataGenerator ().generate (pkg_1, 0, 5);
            
            pkg_1.refDelete ();            
            pkg_2.refDelete ();
            pkg_3.refDelete ();
            pkg.refDelete ();
        } catch (Exception e) {
            System.out.println(e);
            e.printStackTrace ();
            fail (e.getMessage ());
        }        
    }
    
}
