/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.test;

import java.io.*;
import java.util.*;
import java.net.*;

import junit.extensions.*;
import junit.framework.*;

import org.netbeans.api.mdr.*;
import org.openide.util.Lookup;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.lib.jmi.mapping.*;

import javax.jmi.reflect.*;
import javax.jmi.model.*;

import staticfeatures.*;

/**
 * Multivalued index test case.
 */
public class StaticFeaturesTest extends MDRTestCase {

    public StaticFeaturesTest(String testName) {
        super (testName);
    }
    
    public static void main (String[] args) {
        junit.textui.TestRunner.run (suite ());
    }
    
    public static Test suite () {
        TestSuite suite = new TestSuite ();
        suite.addTestSuite (StaticFeaturesTest.class);
        
        TestSetup setup = new TestSetup (suite) {
            public void setUp () {
            }
            public void tearDown () {
            }
        };
        return setup;
    }
    
    // classifier-level attribute test
    public void test_1 () {
        ModelPackage modelPackage = loadMOFModel ("staticFeatures.xml", "model");
        StaticFeaturesPackage pkg = (StaticFeaturesPackage) createExtent (findMofPackage (modelPackage, "StaticFeatures"), "staticFeatures");
        
        int x, y;
        final int MAX = 100;
        final int INT_VALUE = 678;
        Random random = new Random (0);
        
        ClassAClass proxyA = pkg.getClassA (); // staticFieldA (String), staticFieldB (int)
        ClassBClass proxyB = pkg.getClassB ();
        ClassCClass proxyC = pkg.getClassC (); // staticFieldC (int), op. returnParam 
        ClassDClass proxyD = pkg.getClassD (); // staticFieldD (String), staticDerivedField (int), op. compute
        
        if (proxyD.getStaticFieldD() != null)
            fail ();
        proxyD.setStaticFieldD("123");
        proxyB.setStaticFieldA("abcdef");
        
        for (x = 0; x < MAX; x++) {
            int value = random.nextInt ();
            proxyD.setStaticFieldB (value);
            if ((proxyA.getStaticFieldB () != value) || (proxyD.getStaticFieldB () != value))
                fail ();            
        }
                
        proxyD.setStaticFieldC (INT_VALUE);
        
        if (!proxyD.getStaticFieldD().equals("123"))
            fail();
        if (!proxyB.getStaticFieldA().equals("abcdef"))
            fail();
        if (proxyD.getStaticFieldC() != INT_VALUE)
            fail();
                
        proxyD.setStaticFieldC (22);        
        if (!proxyB.getStaticFieldA().equals("abcdef"))
            fail();     
        
        pkg.refDelete ();
        modelPackage.refDelete ();
    }

    // static operator test
    public void test_2 () {
        ModelPackage modelPackage = loadMOFModel ("staticFeatures.xml", "model");
        StaticFeaturesPackage pkg = (StaticFeaturesPackage) createExtent (findMofPackage (modelPackage, "StaticFeatures"), "staticFeatures");
                
        ClassAClass proxyA = pkg.getClassA (); // staticFieldA (String), staticFieldB (int)
        ClassBClass proxyB = pkg.getClassB ();
        ClassCClass proxyC = pkg.getClassC (); // staticFieldC (int), op. returnParam 
        ClassDClass proxyD = pkg.getClassD (); // staticFieldD (String), staticDerivedField (int), op. compute
        
        ClassA objA = proxyA.createClassA ();
        ClassB objB = proxyB.createClassB ();
        ClassD objD = proxyD.createClassD ();
        
        if (!(proxyC.returnParam (objA) == objA)) // proxyC.returnParam (param) always returns 'param'
            fail ();
        if (!(proxyC.returnParam (objB) == objB))
            fail ();
        if (!(proxyC.returnParam (objD) == objD))
            fail ();
        
        if (!(proxyD.returnParam (objA) == objA))
            fail ();
        if (!(proxyD.returnParam (objB) == objB))
            fail ();
        if (!(proxyD.returnParam (objD) == objD))
            fail ();        
        
        List params = new LinkedList ();
        params.add (objD);
        try {
            proxyD.refInvokeOperation ("compute", params);
        } catch (RefException e) {
            fail();
        }
        
        if (proxyD.compute(objD) != 333) // proxyD.compute always returns 333
            fail();                
        
        pkg.refDelete ();
        modelPackage.refDelete ();
    }
    
    // derived classifier-level attribute test
    public void test_3 () {
        ModelPackage modelPackage = loadMOFModel ("staticFeatures.xml", "model");
        StaticFeaturesPackage pkg = (StaticFeaturesPackage) createExtent (findMofPackage (modelPackage, "StaticFeatures"), "staticFeatures");
                        
        ClassDClass proxyD = pkg.getClassD (); // staticFieldD (String), staticDerivedField (int), op. compute
        
        if (proxyD.getStaticDerivedField() != 123)
            fail();
        
        pkg.refDelete ();
        modelPackage.refDelete ();
    }
    
    // classifier-level attribute test using reflective methods
    public void test_reflective () {
        ModelPackage modelPackage = loadMOFModel ("staticFeatures.xml", "model");
        StaticFeaturesPackage pkg = (StaticFeaturesPackage) createExtent (findMofPackage (modelPackage, "StaticFeatures"), "staticFeatures");
        
        int x, y;
        final int MAX = 100;
        final int INT_VALUE = 678;
        Random random = new Random (0);
        
        RefClass proxyA = pkg.getClassA (); // staticFieldA (String), staticFieldB (int)
        RefClass proxyB = pkg.getClassB ();
        RefClass proxyC = pkg.getClassC (); // staticFieldC (int), op. returnParam 
        RefClass proxyD = pkg.getClassD (); // staticFieldD (String), staticDerivedField (int), op. compute
        
        if (proxyD.refGetValue("staticFieldD") != null)
            fail ();
        proxyD.refSetValue("staticFieldD",  "123");
        proxyB.refSetValue("staticFieldA", "abcdef");
        
        for (x = 0; x < MAX; x++) {
            int value = random.nextInt ();
            proxyD.refSetValue("staticFieldB", new Integer(value));
            if ( (((Integer)proxyA.refGetValue("staticFieldB")).intValue() != value) || (((Integer)proxyD.refGetValue("staticFieldB")).intValue() != value))
                fail ();            
        }
                
        proxyD.refSetValue("staticFieldC", new Integer(INT_VALUE));
        
        if (!proxyD.refGetValue("staticFieldD").equals("123"))
            fail();
        if (!proxyB.refGetValue("staticFieldA").equals("abcdef"))
            fail();
        if (((Integer)proxyD.refGetValue("staticFieldC")).intValue() != INT_VALUE)
            fail();
                
        proxyD.refSetValue("staticFieldC", new Integer(22));        
        if (!proxyB.refGetValue("staticFieldA").equals("abcdef"))
            fail();        
        
        pkg.refDelete ();
        modelPackage.refDelete ();
    }
}
