/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.web.monitor.client;

import javax.swing.SwingUtilities;

import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

/**
 * Progress monitor dialog box.
 *
 * @author  Stepan Herold
 */
public class ProgressMonitor extends javax.swing.JDialog {
    
    
    /** 
     * Create new ProgressMonitor.
     */
    public ProgressMonitor() {
        super(WindowManager.getDefault().getMainWindow(), true);
        setModal(true);
        initComponents();
        setBounds(Utilities.findCenterBounds(getSize()));
        setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        setTitle(NbBundle.getMessage(ProgressMonitor.class, "LBL_Delete_Progress_Monitor"));
    }
    
    /**
     * Close progress monitor dialog box.
     */
    public void close() {
        progressBar.setValue(progressBar.getMaximum());
        setVisible(false);
        dispose();
    }

    /**
     * Set progress bar value.
     *
     * @param value new progress bar value from range 0 - 100.
     */
    public void setValue(int value) {
        progressBar.setValue(value);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        progressBar = new javax.swing.JProgressBar();
        label = new javax.swing.JLabel();
        note = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setResizable(false);
        progressBar.setMinimumSize(new java.awt.Dimension(148, 14));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        getContentPane().add(progressBar, gridBagConstraints);

        label.setText(NbBundle.getMessage (ProgressMonitor.class, "MSG_Delete_Progress_Monitor"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 10, 5);
        getContentPane().add(label, gridBagConstraints);

        note.setFont(new java.awt.Font("Dialog", 0, 12));
        note.setText(NbBundle.getMessage (ProgressMonitor.class, "MSG_Delete_Progress_Monitor_note"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 5, 5, 5);
        getContentPane().add(note, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel label;
    private javax.swing.JLabel note;
    private javax.swing.JProgressBar progressBar;
    // End of variables declaration//GEN-END:variables
    
}
