/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.nbbuild;

import org.apache.tools.ant.*;
import org.apache.tools.ant.types.*;
import java.util.StringTokenizer;
import java.io.File;
import java.util.Iterator;

/** Task that reads ModuleTracking informations and composes them into
 * @author Jaroslav Tulach
 */
public class ModuleInfo extends Task {
    private String property;
    private String fileset;
    private String moduleName;
    private String clusterdir;
    private File trackingPath;
    private boolean failOnError;

    public void setModule (String moduleName){
        this.moduleName = moduleName;
    }
    
    public void setPatternSetName( String name ) {
        property = name;
    }
    
    public void setFileSetName (String name) {
        fileset = name;
    }

    public void setClusterDirName (String name) {
        clusterdir = name;
    }
    
    public void setTrackingPath( File path ) {
        trackingPath = path;
    }
    
    public void setFailOnError (boolean b) {
        failOnError = b;
    }
    
    
    public void execute() throws BuildException {
        if (moduleName == null) {
            throw new BuildException("Module property must be set", getLocation());
        }
        if (property == null && fileset == null) {
            throw new BuildException("Name of the patternset or fileset must be set.", getLocation());
        }
        if (trackingPath == null) {
            throw new BuildException("Path to module_tracking.xml file must be set.", getLocation());
        }
        
        String c = this.getProject ().getProperty (moduleName + ".dir");
        if (c == null) {
            throw new BuildException ("No property " + moduleName + ".dir is defined");
        }
        File cluster = new File (c);
        log ("Cluster dir for " + moduleName + " is " + cluster, Project.MSG_VERBOSE);
        
        if (this.clusterdir != null) {
            this.getProject ().setProperty (this.clusterdir, cluster.getPath ());
        }
        
        PatternSet pattern = (PatternSet) this.getProject().createDataType("patternset");
        
        ModuleTracking tracking = new ModuleTracking(trackingPath.getAbsolutePath());
        Iterator files = tracking.getFilesForModule(moduleName);
        if (files==null) {
            String msg = moduleName + " module doesn't have module tracking info in " + trackingPath;
            if (failOnError) {
                throw new BuildException (msg);
            } else {
                log (msg, Project.MSG_ERR);
                files = java.util.Collections.EMPTY_LIST.iterator ();
            }
        }
        
        while (files.hasNext()) {
            String f = (String)files.next ();
            log ("Adding include " + f, Project.MSG_VERBOSE);
            pattern.createInclude().setName(f);
        }
        
        if (property != null) {
            log ("Setting refid " + property);
            this.getProject().addReference(property, pattern);
        }
        
        if (fileset != null) {
            FileSet fs = (FileSet) this.getProject().createDataType("fileset");
            fs.setDir (cluster);
            fs.createPatternSet ().append (pattern, getProject ());
            log ("Setting refid " + fileset);
            this.getProject().addReference(fileset, fs);
        }
    }
}
