/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.nbbuild;

import org.apache.tools.ant.*;
import org.apache.tools.ant.types.*;
import java.util.StringTokenizer;
import java.io.File;
import java.util.Iterator;

/**
 * @author Michal Zlamal
 */
public class SetClusterPatternSet extends Task {
    PatternSet pattern = null;

    private String property = null;
    private String clusterName = null;
    private File trackingPath = null;
    private String clusterDir = null;

    public void setCluster( String cluster ){
        clusterName = cluster;
    }

    public void setName( String name ) {
        property = name;
    }
    
    public void setTrackingPath( File path ) {
        trackingPath = path;
    }
    
    public void setClusterDir( String dir ) {
        clusterDir = dir;
    }
    
    public void execute() throws BuildException {
        if (clusterName == null) {
            throw new BuildException("Cluster property must be set", getLocation());
        }
        if (property == null) {
            throw new BuildException("Name of the patternset must be set.", getLocation());
        }
        if (trackingPath == null) {
            throw new BuildException("Path to module_tracking.xml file must be set.", getLocation());
        }
        if (clusterDir == null) {
            throw new BuildException("Cluster directory must be set.", getLocation());
        }
        
        String clusterList = this.getProject().getProperty(clusterName);
        if (clusterList == null) {
            throw new BuildException("Cluster " + clusterName + " doesn't exist", getLocation());
        }
        pattern = (PatternSet) this.getProject().createDataType("patternset");
        
        ModuleTracking tracking = new ModuleTracking(trackingPath.getAbsolutePath());
        StringTokenizer moduleTokens = new StringTokenizer(clusterList, " \t\n\f\r,");
        while (moduleTokens.hasMoreTokens()) {
            String module = moduleTokens.nextToken();
            Iterator files = tracking.getFilesForModule(module);
            if (files==null) {
                log("This module doesn't have module tracking info: " + module, Project.MSG_INFO);
                continue;
            }
            while (files.hasNext())
                pattern.createInclude().setName(clusterDir + File.separator + (String)files.next());
        }
        
        if (pattern.getIncludePatterns(this.getProject()) == null)
            pattern.createExclude().setName("**");
        
        this.getProject().addReference(property, pattern);
    }
}
