<?xml version="1.0" encoding="ISO-8859-1"?>

<!--
The contents of this file are subject to the terms of the Common Development
and Distribution License (the License). You may not use this file except in
compliance with the License.

You can obtain a copy of the License at http://www.netbeans.org/cddl.html
or http://www.netbeans.org/cddl.txt.

When distributing Covered Code, include this CDDL Header Notice in each file
and include the License file at http://www.netbeans.org/cddl.txt.
If applicable, add the following below the CDDL Header, with the fields
enclosed by brackets [] replaced by your own identifying information:
"Portions Copyrighted [year] [name of copyright owner]"

The Original Software is NetBeans. The Initial Developer of the Original
Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
Microsystems, Inc. All Rights Reserved.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
     xmlns:xlink="http://www.w3c.org/1999/xlink">
 <xsl:output method="html"/>

 <xsl:template match="/">
    <HTML>
        <HEAD>
            <LINK REL ="stylesheet" TYPE="text/css" HREF="http://www.netbeans.org/netbeans.css" TITLE="Style"/>
            <TITLE>Architecture Enhancements</TITLE>
        </HEAD>

        <BODY>
            <H1>Architecture Enhancements</H1>
            <B>Content:</B>
            <xsl:variable name="module_name">openide</xsl:variable>
            <xsl:apply-templates
                select="//module-requirements[@name=$module_name]"
                mode="content"/>
            <hr/>
            <xsl:apply-templates
                select="//module-requirements[@name=$module_name]"/>                                
        </BODY>
    </HTML>
</xsl:template>	   


<!-- dependencies hierarchy -->
<xsl:template match="requirements[requirement]" mode="content"> 
	    <DL>            
	        <xsl:apply-templates select="requirement" mode="content"/>
	    </DL>    
</xsl:template>    

<xsl:template match="module-requirements" mode="content">
    <DL>
        <xsl:apply-templates select="requirement" mode="content">
        <xsl:sort data-type="text" order="ascending" select="@user-impact"/>
        </xsl:apply-templates>
    </DL>
</xsl:template>

<xsl:template match="module-requirements">            
    <TABLE CELLPADDING="1" WIDTH="100%" CELLSPACING="0" BORDER="0" class="tablebg">

        <TR><TD>
            <xsl:apply-templates select="requirement" mode="details">
                <xsl:sort data-type="text" order="ascending" select="@user-impact"/>
            </xsl:apply-templates>
        </TD></TR>
    </TABLE>
</xsl:template>

<xsl:template match="requirement" mode="content">          
    <DD>
        <xsl:call-template name="makeReference">
            <xsl:with-param name="href">#<xsl:value-of select="@name"/></xsl:with-param>
            <xsl:with-param name="title"><xsl:value-of select="@name"/></xsl:with-param>
        </xsl:call-template>   
        <xsl:choose>
          <xsl:when test="string-length(@issue)>0">
            (
            <xsl:call-template name="makeReference">
              <xsl:with-param name="href">
                http://www.netbeans.org/issues/show_bug.cgi?id=<xsl:value-of select="@issue" />
              </xsl:with-param>
              <xsl:with-param name="title">
                #<xsl:value-of select="@issue" />
              </xsl:with-param>
            </xsl:call-template>
            )
            </xsl:when>
        </xsl:choose>    
    </DD>    
    <xsl:apply-templates select="requirements" mode="content"/>        
</xsl:template>

<xsl:template match="requirement" mode="details" >            
   <xsl:if test="@appearance='1'">
    <TABLE BORDER="0" CELLPADDING="3" CELLSPACING="1" WIDTH="100%">

        <TR class="tablecbg">
            <TD ALIGN="CENTER" width="100%" colspan="4">
                <font class="tablecfont"><b>
                    <xsl:call-template name="makeLink">
                        <xsl:with-param name="name"><xsl:value-of select="@name"/>
                        </xsl:with-param>
                        <xsl:with-param name="title"><xsl:value-of select="@name"/>                                 
                        </xsl:with-param>
                    </xsl:call-template>
                    <xsl:choose>
                        <xsl:when test="string-length(@issue)>0">
                            (
                            <xsl:call-template name="makeReference">
                                <xsl:with-param name="href">
                                    http://www.netbeans.org/issues/show_bug.cgi?id=<xsl:value-of select="@issue" />
                                </xsl:with-param>
                                <xsl:with-param name="title">
                                    #<xsl:value-of select="@issue" />
                                </xsl:with-param>
                            </xsl:call-template>
                            )
                        </xsl:when>
                    </xsl:choose>
                </b></font>
            </TD>
        </TR>

        <TR class="tablerbg">
            <TD ALIGN="CENTER" width="25%">Duration:
                <b><xsl:value-of select="@duration"/> days
                </b>
            </TD>

            <TD ALIGN="CENTER" width="25%">Status: <b>
                <xsl:choose>
                    <xsl:when test="string-length(@percentage-complete)>0">
                        <xsl:choose>
                            <xsl:when test="@percentage-complete='0'">
                                <font color="red">Not started</font>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:choose>
                                    <xsl:when test="@percentage-complete='100'">
                                        <font color="green">Done</font>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="@percentage-complete"/>
                                        <xsl:choose>
                                            <xsl:when test="contains(@percentage-complete, 'of')">
                                                <xsl:text disable-output-escaping="yes"></xsl:text>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:text disable-output-escaping="yes">%</xsl:text>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;]]></xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </b></TD>

            <TD ALIGN="CENTER" width="25%">Votes: <b><xsl:value-of select="@votes"/></b></TD>

            <TD ALIGN="CENTER" width="25%">
                <xsl:text disable-output-escaping="yes">User Impact: </xsl:text>
                <xsl:choose>
                    <xsl:when test="@user-impact='high'">
                        <font color="red">
                            <b><xsl:value-of select="@user-impact"/></b>
                        </font>
                    </xsl:when>
                    <xsl:otherwise>
                        <b><xsl:value-of select="@user-impact"/></b>
                    </xsl:otherwise>
                </xsl:choose>
            </TD>
        </TR>
        
        <!-- this table record should be added if at least one available -->        
        <xsl:if test="@date!='' or @keywords!='' or @source!='' or @risk!=''">
	        <TR class="tablerbg">
	            <TD ALIGN="CENTER" width="25%">Date:
	                <b><xsl:value-of select="@date"/></b>
	            </TD>
	            <TD ALIGN="CENTER" width="25%">Keywords:
	                <b><xsl:value-of select="@keywords"/></b>
	            </TD>
	            <TD ALIGN="CENTER" width="25%">Source:
	                <b><xsl:value-of select="@source"/></b>
	            </TD>
	            <TD ALIGN="CENTER" width="25%">Risk:
	                <b><xsl:value-of select="@risk"/></b>
	            </TD>            
	        </TR>
		</xsl:if>

        
        <TR class="tablerbg">
            <TD ALIGN="LEFT" colspan="4" width="100%">
            <xsl:choose>
              <xsl:when test="string-length(long-description)>0" >
                   <xsl:apply-templates select="long-description"/>
              </xsl:when>
              <xsl:otherwise>
                   <xsl:value-of select="short-description" disable-output-escaping="yes"/>
              </xsl:otherwise> 
            </xsl:choose>    
            </TD>
        </TR>
        
        <xsl:if test="user-problem!=''" >         	    
            <TR class="tablerbg">
                <TD ALIGN="LEFT" colspan="4" width="100%">
                    <B>user problem:</B><BR/>
                    <xsl:value-of select="user-problem" disable-output-escaping="yes" />
                </TD>
            </TR>        
        </xsl:if>         
        <xsl:if test="user-need!=''" >         	    
            <TR class="tablerbg">
                <TD ALIGN="LEFT" colspan="4" width="100%">
                    <B>user need:</B><BR/>
                    <xsl:value-of select="user-need" disable-output-escaping="yes" />
                </TD>
            </TR>        
        </xsl:if>

        <TR class="tablerbg">
            <TD ALIGN="LEFT" colspan="2" width="50%">
                
                <xsl:if test="link or req-link" >      
                	<B>links:</B><BR/>                                     
                	<xsl:apply-templates select="link" />
                	<xsl:apply-templates select="req-link" />                                         
                </xsl:if>
                
                <xsl:if test="requirements" >
                  <B>dependencies:</B><BR/>
                  <xsl:apply-templates select="requirements" mode="content" />                                         
                </xsl:if>  
            </TD>
						
            <TD ALIGN="LEFT" colspan="2" width="50%">
                <xsl:choose><xsl:when test="count(roles/person)>0">
                    <DL>
                        <xsl:for-each select="roles/person">
                            <DD>
                                <xsl:choose>
                                    <xsl:when test="string-length(e-mail)>0" >
                                        <xsl:call-template name="makeReference">
                                            <xsl:with-param name="href">mailto:<xsl:value-of select="e-mail"/></xsl:with-param>
                                            <xsl:with-param name="title"><xsl:value-of select="@nickname"/></xsl:with-param>
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="@nickname"/>
                                    </xsl:otherwise> 
                                </xsl:choose> 

                                <xsl:for-each select="role"> - <xsl:value-of select="@name"/>
                                </xsl:for-each>
                            </DD>
                        </xsl:for-each>
                    </DL>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;]]></xsl:text>
                </xsl:otherwise>
                </xsl:choose>
            </TD>
        </TR>
    </TABLE>
    <xsl:apply-templates select="requirements" mode="details"/>
   </xsl:if> 
    
</xsl:template>

<xsl:template match="requirements" mode="details">                              
    <xsl:apply-templates select="requirement" mode="details"/>      
</xsl:template>    


<xsl:template match="body">
    <xsl:copy-of select="./*"/>
</xsl:template>

<xsl:template name="makeLink">
    <xsl:param name="name"  select="''"/>
    <xsl:param name="title" select="''"/>

    <xsl:text disable-output-escaping="yes">&lt;A name="</xsl:text>
    <xsl:value-of select="$name"/>
    <xsl:text disable-output-escaping="yes">"&gt;</xsl:text>
    <xsl:value-of select="$title"/>
    <xsl:text disable-output-escaping="yes">&lt;/A&gt;</xsl:text>
</xsl:template>

<xsl:template name="makeReference">
    <xsl:param name="href"  select="''"/>
    <xsl:param name="title" select="''"/>

    <xsl:text disable-output-escaping="yes">&lt;A href="</xsl:text>
    <xsl:value-of select="$href"/>
    <xsl:text disable-output-escaping="yes">"&gt;</xsl:text>
    <xsl:value-of select="$title"/>
    <xsl:text disable-output-escaping="yes">&lt;/A&gt;</xsl:text>
</xsl:template>

<!-- DEPENDENCIES -->


<xsl:template match="link">
    <xsl:call-template name="makeReference">
                <xsl:with-param name="href"><xsl:value-of select="@href"/></xsl:with-param>
                <xsl:with-param name="title"><xsl:value-of select="."/></xsl:with-param>
     </xsl:call-template><BR/>
</xsl:template>

<!-- requirement reference -->
<xsl:template match="req-link">
    <xsl:call-template name="makeReference">
                <xsl:with-param name="href"><xsl:value-of select="@href"/></xsl:with-param>
                <xsl:with-param name="title"><xsl:value-of select="."/></xsl:with-param>
     </xsl:call-template><BR/>
</xsl:template>

</xsl:stylesheet>
