/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.api.convertor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import org.netbeans.junit.*;
import junit.textui.TestRunner;
import org.netbeans.api.convertor.dvd.DVD;
import org.netbeans.modules.convertor.PropertiesConvertor;
import org.netbeans.spi.convertor.Convertor;
import org.openide.filesystems.Repository;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.w3c.dom.Document;


/**
 *
 * @author  David Konecny
 */
public class DVDConvertorTest extends NbTestCase {
    

    public DVDConvertorTest(String name) {
        super (name);
    }
    
    public static void main(String[] args) {
        TestRunner.run(new NbTestSuite(DVDConvertorTest.class));
    }
    
    protected void setUp () throws Exception {
        Lookup.getDefault().lookup(ModuleInfo.class);
        Repository.getDefault ().getDefaultFileSystem ().getRoot ();
    }
    
    private static Convertor conv;
    
    public static void setupConvertor() throws Exception {
        ModuleUtils.DEFAULT.install();
        ModuleUtils.DEFAULT.enableDVDConvertorModule(true);
    }
    
    public static void removeConvertor() throws Exception {
        ModuleUtils.DEFAULT.enableDVDConvertorModule(false);
        ModuleUtils.DEFAULT.uninstall();
    }
    
    public void testDVDConvertor() throws Exception {
        assertFalse(Convertors.canRead("http://www.netbeans.org/ns/dvd", "dvd"));
        assertFalse(Convertors.canWrite(new DVD()));
        
        setupConvertor();
        
        assertTrue(Convertors.canRead("http://www.netbeans.org/ns/dvd", "dvd"));
        assertTrue(Convertors.canWrite(new DVD()));

//        assertEquals(Convertors.getConvertorDescriptor(new DVD()), new ConvertorDescriptor("http://www.netbeans.org/ns/dvd", "org.netbeans.api.convertor.dvd.DVD"));

        String name = DVDConvertorTest.class.getResource("dvd").getFile() + "/data/DVD.xml";
        InputStream is = new FileInputStream(name);
        DVD d = (DVD)Convertors.read(is);
        assertEquals(d.ID, 125);
        assertEquals(d.title, "Tetsuo");
        assertEquals(d.publisher, "TartanTerror");
        assertEquals(d.price, 19);
        is.close();
        
        
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DVD dvd = new DVD(698, "Zentropa", "TartanClassic", 65);
        Convertors.write(os, dvd);
        
        byte[] ba = os.toByteArray();
        os.close();
        
        ByteArrayInputStream bis = new ByteArrayInputStream(ba);
        Object o = Convertors.read(bis);
        assertEquals(dvd, o);
        
        removeConvertor();
        assertFalse(Convertors.canRead("http://www.netbeans.org/ns/dvd", "dvd"));
        assertFalse(Convertors.canWrite(new DVD()));
    }
    
}
