/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.openide.explorer.view;

import org.openide.awt.ListPane;
import org.openide.explorer.*;
import org.openide.nodes.*;

import java.awt.*;
import java.awt.event.*;

import java.beans.*;

import java.io.*;

import javax.swing.*;


/* TODO:
 - improve cell renderer (two lines of text or hints)
 - better behaviour during scrolling (ListPane)
 - external selection bug (BUG ID: 01110034)
 -
 - XXX if doing anything with this class other than deleting it, rewrite it to use a JTable - that would be
 - much more sensible and scalable.  -Tim
 -
*/

/** A view displaying icons.
*
* @author   Jaroslav Tulach
*/
public class IconView extends ListView implements Externalizable {
    /** generated Serialized Version UID */
    static final long serialVersionUID = -9129850245819731264L;

    public IconView() {
    }

    /** Creates the list that will display the data.
    */
    protected JList createList() {
        JList list = new ListPane() {
                /**
                 * Overrides JComponent's getToolTipText method in order to allow
                 * renderer's tips to be used if it has text set.
                 * @param event the MouseEvent that initiated the ToolTip display
                 */
                public String getToolTipText(MouseEvent event) {
                    if (event != null) {
                        Point p = event.getPoint();
                        int index = locationToIndex(p);

                        if (index >= 0) {
                            VisualizerNode v = (VisualizerNode) getModel().getElementAt(index);
                            String tooltip = v.getShortDescription();
                            String displayName = v.getDisplayName();

                            if ((tooltip != null) && !tooltip.equals(displayName)) {
                                return tooltip;
                            }
                        }
                    }

                    return null;
                }
            };

        list.setCellRenderer(new NodeRenderer());

        return list;
    }
}
