/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.openide.filesystems;

import java.util.*;


/**
 * A class that holds a list of EventListeners.
 * Replacement of  EventListListener, that solves performance issue #20715
 * @author  rm111737
 */
class ListenerList {
    private Class evListenerClass;
    private List listenerList;
    private Object[] listenerArray = null;

    /**
     * @param evListenerClass the type of the EventListener.
     */
    ListenerList(Class evListenerClass) {
        this.evListenerClass = evListenerClass;
        listenerList = Collections.synchronizedList(new ArrayList());
    }

    /**
     * Adds the listener .
     **/
    boolean add(EventListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }

        if (!evListenerClass.isInstance(listener)) {
            return false;
        }

        listenerArray = null;

        return listenerList.add(listener);
    }

    /**
     * Removes the listener .
     **/
    boolean remove(EventListener listener) {
        if (!evListenerClass.isInstance(listener)) {
            return false;
        }

        listenerArray = null;

        return listenerList.remove(listener);
    }

    /**
     * Passes back the event listener list as an array
     */
    Object[] getAllListeners() {
        Object[] retVal = null;

        synchronized (listenerList) {
            retVal = listenerArray;

            if (retVal == null) {
                retVal = new Object[listenerList.size()];
                listenerList.toArray(retVal);
                listenerArray = retVal;
            }
        }

        return retVal;
    }
}
