/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.masterfs;

import org.openide.filesystems.FileObject;

/**
 *
 * @author Radek Matous
 */
abstract class BasedOnResourcePath extends FileObject {
    /** generated Serialized Version UID */
    static final long serialVersionUID = -1244651311117356809L;

    protected ResourcePath resourceNameObj;

    BasedOnResourcePath (ResourcePath resourceNameObj) {
        this.resourceNameObj = resourceNameObj;
    }
    
    public String getNameExt () {
        return resourceNameObj.getNameExt ();        
    }
    /**
     * Implements abstract FileObject.getExt()
     */
    public String getExt() {
        return resourceNameObj.getExt();
    }

    /**
     * Implements abstract FileObject.getName()
     */
    public String getName() {
        return resourceNameObj.getName();
    }

    public String getPath() {
        String p = resourceNameObj.getPath();
        assert !p.startsWith("/") : p;
        return p;
    }

    ResourcePath getResource() {
        return resourceNameObj;
    }

    void setResource(ResourcePath newName) {
        String oldName = resourceNameObj.getNormalizedPath();
        resourceNameObj = newName;
    }

    /**
     * Implements abstract FileObject.isRoot()
     */
    public boolean isRoot() {
        return (getResource().getParent() == null) ? true : false;
    }

}
