/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.masterfs;

import org.openide.filesystems.*;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;

/**
 * Implements FileObject methods as simple as possible.
 * @author Radek Matous
 */
class InvalidDummy extends BasedOnResourcePath {
    /** generated Serialized Version UID */
    static final long serialVersionUID = -1244651321997356809L;

    protected InvalidDummy(ResourcePath resourcePath) {
        super (resourcePath);
    }
    
    public FileSystem getFileSystem() throws FileStateInvalidException {
        throw new FileStateInvalidException(getPath());
    }

    public void rename(FileLock lock, String name, String ext) throws IOException {
        throw new IOException(getPath());
    }


    public void delete(FileLock lock) throws IOException {
        throw new IOException(getPath());
    }

    public InputStream getInputStream() throws FileNotFoundException {
        throw new FileNotFoundException(getPath());
    }

    public OutputStream getOutputStream(FileLock lock) throws IOException {
        throw new IOException(getPath());
    }

    public FileLock lock() throws IOException {
        throw new IOException(getPath());
    }

    public FileObject createFolder(String name) throws IOException {
        throw new IOException(getPath());
    }

    public FileObject createData(String name, String ext) throws IOException {
        throw new IOException(getPath());
    }


    public Object getAttribute(String attrName) {
        return null;
    }

    public void setAttribute(String attrName, Object value) throws IOException {
        throw new IOException(getPath());
    }

    public Enumeration getAttributes() {
        return org.openide.util.Enumerations.empty();
    }

    public void addFileChangeListener(FileChangeListener fcl) {
    }

    public void removeFileChangeListener(FileChangeListener fcl) {
    }

    public long getSize() {
        return 0;
    }

    public void setImportant(boolean b) {
    }

    public FileObject[] getChildren() {
        return new FileObject[]{};
    }

    public FileObject getFileObject(String name, String ext) {
        return null;
    }


    public boolean isReadOnly() {
        return true;
    }

    public FileObject getParent() {
        return null;
    }

    public boolean isFolder() {
        return false;
    }

    public Date lastModified() {
        if (isRoot())
            return new Date(0);
        return new java.util.Date();
    }

    public boolean isData() {
        return true;
    }

    public boolean isValid() {
        return false;
    }

    public String getMIMEType() {
        return "content/unknown"; // NOI18N
    }

}
