/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.masterfs;

import java.util.Collections;
import java.util.WeakHashMap;

/**
 *
 * @author  rm111737
 */
final class SyncSection {
    /** sync. purpose*/
    private int exclusiveCounter;
    private int normalCounter;
    final private ThreadLocal normalCounterPerThread = new ThreadLocal();
    final private ThreadLocal exclusiveCounterPerThread = new ThreadLocal();
    final private Object sync = new Object();
    private static SyncSection instance;


    static SyncSection getDefault() {
        synchronized (Cache.class) {
            if (instance == null) {
                instance = new SyncSection();
            }
        }
        return instance;
    }

    /** Creates a new instance of SyncSection */
    private SyncSection() {
    }

    void enterSection() {
        synchronized (sync) {
            try {
                while ((exclusiveCounter - getValue(exclusiveCounterPerThread)) > 0) {
                    sync.wait();
                }

                normalCounter++;
                setValue(normalCounterPerThread, getValue(normalCounterPerThread) + 1);
            } catch (InterruptedException iex) {
                iex.printStackTrace();
            }
        }
    }

    void finishSection() {
        synchronized (sync) {
            normalCounter--;
            setValue(normalCounterPerThread, getValue(normalCounterPerThread) - 1);
            sync.notifyAll();
        }

    }

    /** there should be prevented to call exclusive section from norma sectin, because of
     * danger of deadlock. Thread, that enters exclusive section should avoid to keep
     * locks, that could prevent to finish normal section.
     */
    void enterExclusiveSection() {
        synchronized (sync) {
            try {
                while ((normalCounter - getValue(normalCounterPerThread)) > 0 ||
                        (exclusiveCounter - getValue(exclusiveCounterPerThread)) > 0) {
                    sync.wait();
                }
            } catch (InterruptedException iex) {
                iex.printStackTrace();
            }
            exclusiveCounter++;
            setValue(exclusiveCounterPerThread, getValue(exclusiveCounterPerThread) + 1);

        }
    }

    void finishExclusiveSection() {
        synchronized (sync) {
            exclusiveCounter--;
            setValue(exclusiveCounterPerThread, getValue(exclusiveCounterPerThread) - 1);
            sync.notifyAll();
        }
    }

    private int getValue(ThreadLocal thrVal) {
        Integer val = (Integer) thrVal.get();
        return (val != null) ? val.intValue() : 0;
    }

    private void setValue(ThreadLocal thrVal, int value) {
        thrVal.set(new Integer(value));
    }

}
