/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.masterfs;

import org.openide.filesystems.*;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.ErrorManager;

import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Iterator;
import java.util.HashSet;
import java.awt.*;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;

public class Utils {

    static String getString(String s) {
        try {
            return NbBundle.getBundle("org.netbeans.modules.masterfs.resources.Bundle", //NOI18N
                    java.util.Locale.getDefault(), MasterFileSystem.class.getClassLoader()).getString(s);
        } catch (MissingResourceException msx) {
            return "";
        }
    }

    static String formatString(String excName, Object[] args) {
        String format = getString(excName);
        if (args == null)
            return format;
        else
            return java.text.MessageFormat.format(format, args);
    }

    static void throwIOException(String format, Object[] args) throws IOException {
        throwIOException(new IOException(formatString(format, args)));
    }

    static void throwIOException(IOException exc2Fire) throws IOException {
        ErrorManager.getDefault().annotate(exc2Fire, ErrorManager.WARNING, null,
                exc2Fire.getLocalizedMessage(), null, null);
        throw exc2Fire;
    }

    static Image getRootIcon(int iconType, Object obj) {
        try {
            BeanInfo bI = Utilities.getBeanInfo(obj.getClass());
            Image img = bI.getIcon(iconType);
            return img;
        } catch (IntrospectionException iex) {
            return null;
        }
    }

    static Set transformSet (final Set files) {
        final Set transformedSet = new HashSet ();
        
        Iterator it = files.iterator();
        while (it.hasNext()) {
            MasterFileObject mfo = (MasterFileObject)it.next();
            FileObject fo = mfo.getDelegate().get(true);
            if (fo != null) {
                transformedSet.add(fo);            
            }
        }
        return transformedSet;
    }
    

    static ResourcePath getResource (File f) {
        String path;
        try {
            path = f.getCanonicalPath();
        } catch (IOException iex) {
            path = f.getAbsolutePath();
        }
        return new ResourcePath (path);
    }

    static Set transformToDelegates(java.util.Set foSet, boolean prefered) {
        Set retVal = new HashSet();
        Iterator it = foSet.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof MasterFileObject) {
                FileObject fo;
                if (prefered) {                  
                    MasterFileObject hfo = (MasterFileObject) obj;
                    fo = hfo.getDelegate().getPrefered();
                } else {
                    MasterFileObject hfo = (MasterFileObject) obj;
                    fo = hfo.getDelegate().get();
                }

                if (fo != null)
                    retVal.add(fo);
            }
        }
        return retVal;
    }

}
