/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.masterfs.providers;

import org.netbeans.modules.masterfs.providers.AutoMountProvider;

/**
 *
 * An object that implements FileSystemProvider have chance to affect behaviour of
 * MasterFileSystem. MasterFileSystem delegates its functionality to mounted FileSystems.
 * So, behaviour of MasterFileSystem can be affected easily by mounting its own
 * implemenation of FileSystem.
 *
 * <P>There are two ways how to mount FileSystem into MasterFileSystem:
 * <UL>
 * <LI> <b>automatic mounting</b> means,
 * that there is not necessary to call MountSupport
 * to mount filesystem into MasterFileSystem. On the contrary MasterFileSystem
 * invokes individual AutoMountProviders to obtain instance of FileSystem, that should
 * be mounted. Then {@link org.netbeans.modules.masterfs.providers.AutoMountProvider}
 * must be able to return best suited filesystem for passed mount point or null.
 *

 * </LI>
 * <LI> <b>user mounting</b> is simply {@link org.netbeans.modules.masterfs.providers.MountSupport},
 * which is API, that has two methods mount and unmount.
 * </LI>
 * </UL> <P>
 *
 *
 * @see org.netbeans.modules.masterfs.providers.MountSupport
 * @see org.netbeans.modules.masterfs.providers.AutoMountProvider
 * @author  rm111737
 */
public abstract interface FileSystemProvider {
    /**
     * Implementation of method initialize may support:
     * <UL>
     * <LI> <b>automatic mounting</b>, then method initialize mustn't return null. </LI>
     * <LI> <b>user mounting</b>, then MountSupport passed to method initalize needs to be kept.</LI>
     * <LI> both above mentioned</LI>
     * </UL>
     * @param mSupport instance of MountSupport provided by MasterFileSystem
     * @return  instance of  AutoMountProvider if there is supported <b>automatic mounting</b>
     */
    public abstract AutoMountProvider initialize (MountSupport mSupport);

}
