/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.masterfs;

import junit.framework.*;
import org.netbeans.junit.NbTestCase;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.filesystems.FileUtil;
import java.net.URL;

/**
 * @author Radek Matous
 */
public class MasterURLMapperTest extends NbTestCase {
    
    public MasterURLMapperTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(MasterURLMapperTest.class);
        
        return suite;
    }

    public void testGetURL64012() throws Exception {
        int type = URLMapper.NETWORK;        
        FileObject fo = FileUtil.toFileObject(getWorkDir());        
        assertNotNull(fo);
        
        MasterURLMapper instance = new MasterURLMapper();        
        URL result = instance.getURL(fo, type);
        assertNull(result);//NOI18N
    }
    
}
