/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.openide.windows;

import java.io.ObjectInputStream;
import junit.framework.TestCase;
import org.openide.util.io.NbMarshalledObject;

/**
 *
 * @author mkleint
 */
public class TopComponentTest extends TestCase {
    
    public TopComponentTest(String testName) {
        super(testName);
    }
    
    /**
     * Test of readExternal method, of class org.openide.windows.TopComponent.
     */
    public void testReadExternal() throws Exception {
        // first try tc with displayname
        TopComponent tc = new TopComponent();
        tc.setName("testName");
        tc.setDisplayName("testdisplayName");
        tc.setToolTipText("testTooltip");
        NbMarshalledObject obj = new NbMarshalledObject (tc);
        tc.close ();
        
        tc = (TopComponent)obj.get ();
        assertNotNull ("One again", tc);
        assertEquals("testName", tc.getName());
        assertEquals("testTooltip", tc.getToolTipText());
        assertEquals("testdisplayName", tc.getDisplayName());
        
        // now try tc withOUT displayname
        tc = new TopComponent();
        tc.setName("testName");
        tc.setToolTipText("testTooltip");
        obj = new NbMarshalledObject (tc);
        tc.close ();
        
        tc = (TopComponent)obj.get ();
        assertNotNull ("One again", tc);
        assertEquals("testName", tc.getName());
        assertEquals("testTooltip", tc.getToolTipText());
        assertNull(tc.getDisplayName());
        
    }

    /**
     * Test of readExternal method, of class org.openide.windows.TopComponent.
     */
    public void testOldReadExternal() throws Exception {
        TopComponent tc = null;
        try {
            ObjectInputStream stream = new ObjectInputStream(
                   getClass().getResourceAsStream("data/oldTcWithoutDisplayName.ser"));
            tc = (TopComponent)stream.readObject();
            stream.close();
        } catch (Exception exc) {
            exc.printStackTrace();
            fail("Cannot read tc");
        }
        
        
        assertNotNull ("One again", tc);
        assertEquals("testName", tc.getName());
        assertEquals("testTooltip", tc.getToolTipText());
        assertEquals("testdisplayName", tc.getDisplayName());
    }
    
    
    
//    public void testXXX() {
//        File fil = new File("/Users/mkleint/oldTcWithoutDisplayName.ser");
//        TopComponent tc = new TopComponent();
//        tc.setName("testName");
//        tc.setDisplayName("testdisplayName");
//        tc.setToolTipText("testTooltip");1
//        System.out.println("file=" + fil);
//        try {
//            ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(fil));
//            stream.writeObject(tc);
//            stream.close();
//        } catch (Exception exc) {
//            System.out.println("exception");
//        }
//        // TODO code application logic here        
//    }


    
}
