/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.project.uiapi;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 * @author  phrebejk
 */
public class CustomizerPane extends JPanel
        implements HelpCtx.Provider, PropertyChangeListener {
    
    public static final String HELP_CTX_PROPERTY = "helpCtxProperty";
    
    private Component currentCustomizer;
    private JTextArea errorMessageValue = new JTextArea();
    private HelpCtx currentHelpCtx;
    
    private GridBagConstraints fillConstraints;
    private GridBagConstraints errMessConstraints = new GridBagConstraints();
    
    private ProjectCustomizer.CategoryComponentProvider componentProvider;
    
    //private DialogDescriptor dialogDescriptor;
    
    /** Creates new form J2SECustomizer */
    public CustomizerPane( JPanel categoryView, CategoryModel categoryModel, ProjectCustomizer.CategoryComponentProvider componentProvider ) {
        initComponents();
        // HelpCtx.setHelpIDString( customizerPanel, "org.netbeans.modules.java.j2seproject.ui.customizer.J2SECustomizer" ); // NOI18N
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPane.class,"AD_CustomizerPane")); // NOI18N
        this.componentProvider = componentProvider;
        fillConstraints = new GridBagConstraints();
        fillConstraints.gridwidth = GridBagConstraints.REMAINDER;
        fillConstraints.gridheight = 1;
        fillConstraints.fill = GridBagConstraints.BOTH;
        fillConstraints.weightx = 1.0;
        fillConstraints.weighty = 1.0;
        categoryModel.addPropertyChangeListener( new CategoryChangeListener() );
        categoryPanel.add( categoryView, fillConstraints );
        
        // init errorMessageValue
        errorMessageValue.setWrapStyleWord(true);
        errorMessageValue.setLineWrap(true);
        errorMessageValue.setBorder(BorderFactory.createEmptyBorder());
        errorMessageValue.setEditable(false);
        errorMessageValue.setForeground(UIManager.getColor("nb.errorForeground")); // NOI18N
        errorMessageValue.setBackground(customizerPanel.getBackground());
        
        // put it into under categoryView
        errMessConstraints = new GridBagConstraints();
        errMessConstraints.gridx = 0;
        errMessConstraints.gridy = 1;
        errMessConstraints.gridwidth = 1;
        errMessConstraints.gridheight = 1;
        errMessConstraints.insets = new Insets(12, 0, 0, 0);
        errMessConstraints.fill = GridBagConstraints.HORIZONTAL;
        customizerPanel.add(errorMessageValue, errMessConstraints);
        
        setCategory( categoryModel.getCurrentCategory() );
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        categoryPanel = new javax.swing.JPanel();
        customizerPanel = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        setPreferredSize(new java.awt.Dimension(750, 450));
        jLabel1.setLabelFor(categoryPanel);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(CustomizerPane.class, "LBL_Customizer_Categories"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 11, 0, 0);
        add(jLabel1, gridBagConstraints);

        categoryPanel.setLayout(new java.awt.GridBagLayout());

        categoryPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        categoryPanel.setMinimumSize(new java.awt.Dimension(220, 4));
        categoryPanel.setPreferredSize(new java.awt.Dimension(220, 4));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 11, 8, 11);
        add(categoryPanel, gridBagConstraints);

        customizerPanel.setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 8, 11);
        add(customizerPanel, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel categoryPanel;
    private javax.swing.JPanel customizerPanel;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables
    
    
    // HelpCtx.Provider implementation -----------------------------------------
    
    public HelpCtx getHelpCtx() {        
        return currentHelpCtx;        
        /*
        System.out.println("Get Help Ctx");
        Thread.dumpStack();
        
        if ( currentCustomizer != null  ) {
            // System.out.println( "C " + HelpCtx.findHelp( currentCustomizer )  );
            return HelpCtx.findHelp( currentCustomizer );
        }
        /*
        else {
            // System.out.println( "P " + HelpCtx.findHelp( currentCustomizer )  );
            return HelpCtx.findHelp( customizerPanel );
        }
              
        // XXX
        return null;
        */
    }
    
    
    // Private methods ---------------------------------------------------------
    
    private void setCategory( ProjectCustomizer.Category newCategory) {
        if ( newCategory == null ) {
            return;
        }

        if ( currentCustomizer != null ) {
            customizerPanel.remove( currentCustomizer );
        }

        JComponent newCustomizer = componentProvider.create( newCategory );

        if ( newCustomizer != null ) {
            Utilities.getCategoryChangeSupport(newCategory).addPropertyChangeListener(this);
            currentCustomizer = newCustomizer;            
            currentHelpCtx = HelpCtx.findHelp( currentCustomizer );
            
            /*
            if ( currentCustomizer instanceof javax.swing.JComponent ) {
                ((javax.swing.JComponent)currentCustomizer).setPreferredSize( new java.awt.Dimension( 600, 0 ) );
            }
            */
            customizerPanel.add( currentCustomizer, fillConstraints );
            customizerPanel.validate();
            customizerPanel.repaint();
            
            setErrorMessage(newCategory.getErrorMessage());
            firePropertyChange( HELP_CTX_PROPERTY, null, getHelpCtx() );
        }
        else {
            currentCustomizer = null;
        }

    }

    private void setErrorMessage(String errMessage) {
        errorMessageValue.setText(errMessage);
        if (errMessage == null || errMessage.trim().equals("")) {
            customizerPanel.remove(errorMessageValue);
        } else {
            customizerPanel.add(errorMessageValue, errMessConstraints);
        }
        customizerPanel.revalidate();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == CategoryChangeSupport.ERROR_MESSAGE_PROPERTY) {
            String errMessage = (String) evt.getNewValue();
            setErrorMessage(errMessage);
        }
    }
    
    // Private innerclasses ----------------------------------------------------
                
    /** Listens to selection change and shows the customizers as
     *  panels
     */        
    private class CategoryChangeListener implements PropertyChangeListener {
        
        public void propertyChange(PropertyChangeEvent evt) {
            
            if ( CategoryModel.PROP_CURRENT_CATEGORY.equals( evt.getPropertyName() ) ) {                                
                ProjectCustomizer.Category newCategory = (ProjectCustomizer.Category)evt.getNewValue();
                setCategory( newCategory );
            }
        }
    }

}
