/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.experimental;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.classpath.Util;
import org.netbeans.modules.refactoring.api.*;
import org.openide.filesystems.FileObject;

/**
 * @author Daniel Prusa
 */
public final class IntroduceVariableRefactoring extends AbstractRefactoring {    
    
    private Expression expression;
    private String variableName;
    private Type variableType;
    private boolean replaceAll;
    private boolean isFinal;
    
    /**
     * Creates a new instance of IntroduceVariableRefactoring
     * @param expression Expression the new local variable should be introduced for
     */
    public IntroduceVariableRefactoring(Element elem, int startOffset, int endOffset) {
        if (startOffset == -1 || endOffset == -1) {
            if (elem instanceof Expression) {
                this.expression = (Expression) elem;
            }
        } else {
            Resource resource = elem.getResource();
            Element startElem = resource.getElementByOffset(startOffset);
            Element endElem = resource.getElementByOffset(endOffset-1);
            this.expression = findSelection(startElem, endElem);
        }
    }
    
    /**
     * Getter for property variableName
     * @return Value of property variableName
     */
    public String getVariableName() {
        return variableName;
    }
    
    /**
     * Setter for propety variableName
     * @param variableName New value of property variableName
     */
    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }
     
    /**
     * Getter for property variableType
     * @return Value of property variableType
     */
    public Type getVariableType() {
        return variableType;
    }
    
    /**
     * Setter for propety variableType
     * @param varType New value of property variableType
     */
    public void setVariableType(Type varType) {
        this.variableType = varType;
    }
    
    /**
     * Getter for propety replaceAll
     * @return Value of property replaceAll
     */
    public boolean isReplaceAll() {
        return replaceAll;
    }
    
    /**
     * Setter for propety replaceAll
     * @param replaceAll New value of property replaceAll
     */
    public void setReplaceAll(boolean replaceAll) {
        this.replaceAll = replaceAll;
    }
    
    /**
     * Getter for propety isFinal
     * @return Value of property isFinal
     */
    public boolean isFinal() {
        return isFinal;
    }
    
    /**
     * Setter for propety isFinal
     * @param replaceAll New value of property isFinal
     */
    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }
    
    /**
     * Getter for property expression
     * @return expression
     */
    public Expression getExpression() {
        return expression;
    }
    
    protected void setClassPath() {
        Util.setClassPath((Element) expression);
    }

    // helper methods ..........................................................
    
    private Expression findSelection(Element startElem, Element endElem) {
        Set parents = new HashSet();
        Element elem = startElem;
        while (elem instanceof Expression) {
            parents.add(elem);
            elem = (Element) elem.refImmediateComposite();
        }
        elem = endElem;
        while (elem instanceof Expression) {
            if (parents.contains(elem)) {
                return (Expression)elem;
            }
            elem = (Element) elem.refImmediateComposite();
        }
        return null;
    }
    
}
