/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Leon Chiver. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.experimental.ui;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.refactoring.experimental.CleanUpRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.ui.UIUtilities;

/**
 * @author  leon
 */
public class CleanUpPanel extends CustomRefactoringPanel {

    private CleanUpRefactoring refactoring;
    
    private List/*<Resource>*/ elements;
    
    public CleanUpPanel(CleanUpRefactoring refactoring, List/*<Resource>*/ elements) {
        this.refactoring = refactoring;
        this.elements = elements;
        initComponents();
    }
    
    List/*<Resource>*/ getSelectedResources() {
        return ((ResourceTableModel) elementsTable.getModel()).getSelectedElements();
    }
    
    boolean isCommentInsteadOfRemoving() {
        return commentInsteadOfRemovingCheckBox.isSelected();
    }
    
    boolean isRemoveUnusedImports() {
        return removeUnusedImportsCheckBox.isSelected();
    }
    
    boolean isRemoveUnusedFields() {
        return removeUnusedElementsCheckBox.isSelected();
    }
    
    boolean isRemoveUnusedCallableFeatures() {
        return removeUnusedElementsCheckBox.isSelected();
    }
    
    boolean isRemoveUnusedLocalVars() {
        return removeUnusedElementsCheckBox.isSelected();
    }
    
    boolean isRemoveRedundantCasts() {
        return removeRedundantCastsCheckBox.isSelected();
    }
    
    boolean isRemoveUnusedClasses() {
        return removeUnusedElementsCheckBox.isSelected();
    }
    
    public void initialize() {
        elementsTable.setModel(new ResourceTableModel());
        elementsTable.setDefaultRenderer(Resource.class, new UIUtilities.JavaElementTableCellRenderer());
        UIUtilities.initColumnWidth(elementsTable, 0, Boolean.TRUE, 4);
        elementsScrollPane.setBackground(elementsTable.getBackground());
        elementsScrollPane.getViewport().setBackground(elementsTable.getBackground());
        // set default row height
        elementsTable.setRowHeight(18);
        // set grid color to be consistent with other netbeans tables
        if (UIManager.getColor("control") != null) { // NOI18N
            elementsTable.setGridColor(UIManager.getColor("control")); // NOI18N
        }
    }
    
    public void addNotify() {
        super.addNotify();
        elementsTable.changeSelection(0, 0, true, false);
        elementsTable.editCellAt(0, 0);
        elementsTable.requestFocus();
    }
    
    private class ResourceTableModel extends AbstractTableModel {
        
        private BitSet skippedResourceMask;
        
        public ResourceTableModel() {
            skippedResourceMask = new BitSet(elements.size());
        }
        
        public int getColumnCount() {
            return 2;
        }
        
        public int getRowCount() {
            return elements.size();
        }
        
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.valueOf(!skippedResourceMask.get(rowIndex));
            } else {
                return elements.get(rowIndex);
            }
        }
        
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            skippedResourceMask.set(rowIndex, !((Boolean) aValue).booleanValue());
        }
        
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }
        
        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            } else {
                return Resource.class;
            }
        }
        
        public String getColumnName(int column) {
            return column == 0 ? 
                "" : // NOI18N
                org.openide.util.NbBundle.getMessage(CleanUpPanel.class, "LBL_JavaClassFile"); // NOI18N
        }
        
        public List/*<Resource>*/ getSelectedElements() {
            int sz = elements.size();
            List/*<Resource>*/ result = new ArrayList/*<Resource>*/();
            for (int i = 0; i < sz; i++) {
                if (!skippedResourceMask.get(i)) {
                    result.add(elements.get(i));
                }
            }
            return result;
        }
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        elementsLabel = new javax.swing.JLabel();
        elementsScrollPane = new javax.swing.JScrollPane();
        elementsTable = new javax.swing.JTable();
        removeUnusedElementsCheckBox = new javax.swing.JCheckBox();
        removeRedundantCastsCheckBox = new javax.swing.JCheckBox();
        removeUnusedImportsCheckBox = new javax.swing.JCheckBox();
        commentInsteadOfRemovingCheckBox = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(elementsLabel, org.openide.util.NbBundle.getMessage(CleanUpPanel.class, "LBL_ClassesFiles"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(elementsLabel, gridBagConstraints);

        elementsScrollPane.setOpaque(false);
        elementsScrollPane.setPreferredSize(new java.awt.Dimension(453, 180));
        elementsScrollPane.setViewportView(elementsTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.6;
        add(elementsScrollPane, gridBagConstraints);

        removeUnusedElementsCheckBox.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(removeUnusedElementsCheckBox, org.openide.util.NbBundle.getMessage(CleanUpPanel.class, "LBL_RemoveUnusedElements"));
        removeUnusedElementsCheckBox.setToolTipText(org.openide.util.NbBundle.getMessage(CleanUpPanel.class, "TXT_UnusedElementsToolTip"));
        removeUnusedElementsCheckBox.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(0, 0, 0, 0)));
        removeUnusedElementsCheckBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        removeUnusedElementsCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                removeUnusedElementsCheckBoxStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        add(removeUnusedElementsCheckBox, gridBagConstraints);

        removeRedundantCastsCheckBox.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(removeRedundantCastsCheckBox, org.openide.util.NbBundle.getMessage(CleanUpPanel.class, "LBL_RemoveObsoleteCasts"));
        removeRedundantCastsCheckBox.setToolTipText(org.openide.util.NbBundle.getMessage(CleanUpPanel.class, "TXT_RedundantCastsToolTip"));
        removeRedundantCastsCheckBox.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(0, 0, 0, 0)));
        removeRedundantCastsCheckBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        add(removeRedundantCastsCheckBox, gridBagConstraints);

        removeUnusedImportsCheckBox.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(removeUnusedImportsCheckBox, org.openide.util.NbBundle.getMessage(CleanUpPanel.class, "LBL_RemoveUnusedImports"));
        removeUnusedImportsCheckBox.setToolTipText(org.openide.util.NbBundle.getMessage(CleanUpPanel.class, "TXT_RemoveImportsToolTip"));
        removeUnusedImportsCheckBox.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(0, 0, 0, 0)));
        removeUnusedImportsCheckBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        add(removeUnusedImportsCheckBox, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(commentInsteadOfRemovingCheckBox, org.openide.util.NbBundle.getMessage(CleanUpPanel.class, "LBL_CommentOut"));
        commentInsteadOfRemovingCheckBox.setToolTipText(org.openide.util.NbBundle.getMessage(CleanUpPanel.class, "TXT_CommentOut"));
        commentInsteadOfRemovingCheckBox.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(0, 0, 0, 0)));
        commentInsteadOfRemovingCheckBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        add(commentInsteadOfRemovingCheckBox, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents

    private void removeUnusedElementsCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_removeUnusedElementsCheckBoxStateChanged
        commentInsteadOfRemovingCheckBox.setEnabled(removeUnusedElementsCheckBox.isSelected());
    }//GEN-LAST:event_removeUnusedElementsCheckBoxStateChanged
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox commentInsteadOfRemovingCheckBox;
    private javax.swing.JLabel elementsLabel;
    private javax.swing.JScrollPane elementsScrollPane;
    private javax.swing.JTable elementsTable;
    private javax.swing.JCheckBox removeRedundantCastsCheckBox;
    private javax.swing.JCheckBox removeUnusedElementsCheckBox;
    private javax.swing.JCheckBox removeUnusedImportsCheckBox;
    // End of variables declaration//GEN-END:variables
    
}
