/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.experimental.ui;
import org.netbeans.jmi.javamodel.ArrayAccess;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.experimental.IntroduceVariableRefactoring;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 * @author Daniel Prusa
 */
public class IntroduceVariableRefactoringUI implements RefactoringUI {
    private final IntroduceVariableRefactoring refactoring;
    private Expression expression;
    private IntroduceVariablePanel panel;

    public IntroduceVariableRefactoringUI(Element element, int startOffset, int endOffset) {
        refactoring = new IntroduceVariableRefactoring(element, startOffset, endOffset);
        this.expression = refactoring.getExpression();
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(org.netbeans.modules.refactoring.spi.ui.ParametersPanel parent) {
        if (panel == null) {
            Type[] types;
            if (expression != null) {
                Type type = null;
                if (expression instanceof ArrayAccess) { // [TODO] this is workaroung, getType() should work
                    type = ((org.netbeans.jmi.javamodel.Array)((ArrayAccess) expression).getArray().getType()).getType();
                } else {
                    type = expression.getType();
                }
                if (type == null) {
                    JavaModelPackage pkg = (JavaModelPackage) expression.refOutermostPackage();
                    type = pkg.getType().resolve("java.lang.Object"); // NOI18N
                }
                types = new Type[] {type};
            } else {
                types = new Type[0];
            }
            panel = new IntroduceVariablePanel(parent, "lokalek", types); // [TODO] // NOI18N
        }
        return panel;
    }

    public org.netbeans.modules.refactoring.api.Problem setParameters() {
        refactoring.setVariableName(panel.getVariableName());
        refactoring.setFinal(panel.declareFinal());
        refactoring.setReplaceAll(panel.replaceAllOccurrences());
        refactoring.setVariableType(panel.getVariableType());
        return refactoring.checkParameters();
    }
    
    public org.netbeans.modules.refactoring.api.Problem checkParameters() {
        /*
        newName = panel.getNameValue();
        if (refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring) refactoring).setNewName(newName);
        } else {
            ((MoveClassRefactoring) refactoring).setNewPackageName(newName);
        }
         */
        return refactoring.fastCheckParameters();
    }

    public org.netbeans.modules.refactoring.api.AbstractRefactoring getRefactoring() {
        return refactoring;
    }

    public String getDescription() {
        return ""; // NOI18N [TODO]
        /*
        return new MessageFormat(NbBundle.getMessage(IntroduceVariableAction.class, "DSC_IntroduceVariable")).format (
                    new Object[] {dispOldName, newName}
                );
         */
    }

    public String getName() {
        return NbBundle.getMessage(IntroduceVariableAction.class, "LBL_IntroduceVariable");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(IntroduceVariableRefactoringUI.class.getName());
    }
}
