/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring;

import java.lang.reflect.Modifier;
import java.util.Collections;
import org.netbeans.jmi.javamodel.IntLiteral;
import org.netbeans.jmi.javamodel.PrefixExpression;
import org.netbeans.jmi.javamodel.Assignment;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.InfixExpression;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.Operator;
import org.netbeans.jmi.javamodel.OperatorEnum;
import org.netbeans.jmi.javamodel.PrimaryExpression;
import org.netbeans.jmi.javamodel.VariableAccess;

/**
 *
 * @author  Tomas Hurka
 */
public class EncapsulateFieldElement extends WhereUsedElement {
    private String getterName,setterName;
    private boolean isAssign;
    private boolean hasSuper;
    private PrimaryExpression parentClass;
    private JavaModelPackage model;
    
    public EncapsulateFieldElement(Field encapsulatedField,VariableAccess usage,String getter,String setter, boolean enabled, boolean writeAccess) {
        super(encapsulatedField,usage);
        setEnabled(enabled);
        getterName=getter;
        setterName=setter;
        isAssign=writeAccess;
        hasSuper=usage.isHasSuper();
        parentClass=usage.getParentClass();
        model=(JavaModelPackage)feature.refImmediatePackage();
    }
    
    private MethodInvocation createSetGet(Operator oper,Expression rightSide) {
        MethodInvocation readMethod;
        InfixExpression infixExpr;
        PrimaryExpression dupParent;
        
        if (rightSide instanceof InfixExpression) {
            rightSide=model.getComplexExpression().createComplexExpression(rightSide);
        }
        readMethod=model.getMethodInvocation().createMethodInvocation(getterName, null, parentClass, hasSuper);
        infixExpr=model.getInfixExpression().createInfixExpression(readMethod, oper, rightSide);
        dupParent=parentClass==null?null:(PrimaryExpression)parentClass.duplicate();
        return model.getMethodInvocation().createMethodInvocation(setterName, Collections.singletonList(infixExpr), dupParent, hasSuper);
    }
    
    public void performChange() {
        Element parent=(Element)feature.refImmediateComposite();
        
        ((VariableAccess)feature).setParentClass(null);
        if (!isAssign) { // read access
            MethodInvocation method=model.getMethodInvocation().createMethodInvocation(getterName, null, parentClass, hasSuper);
            
            parent.replaceChild(feature, method);
        } else {
            Element assignParent=(Element)parent.refImmediateComposite();
            MethodInvocation setterMethod;
            
            if (parent instanceof Assignment) {
                Assignment assign=(Assignment)parent;
                Operator oper=assign.getOperator();
                Expression value=assign.getRightSide();

                assign.setRightSide(null);
                if (oper.equals(OperatorEnum.ASSIGN)) { 
                    setterMethod=model.getMethodInvocation().createMethodInvocation(setterName, Collections.singletonList(value), parentClass, hasSuper);
                } else if (oper.equals(OperatorEnum.ANDASSIGN)) {
                    setterMethod=createSetGet(OperatorEnum.AND,value);
                } else if (oper.equals(OperatorEnum.DIVASSIGN)) {
                    setterMethod=createSetGet(OperatorEnum.DIV,value);
                } else if (oper.equals(OperatorEnum.LSHIFTASSIGN)) {
                    setterMethod=createSetGet(OperatorEnum.LSHIFT,value);
                } else if (oper.equals(OperatorEnum.MINUSASSIGN)) {
                    setterMethod=createSetGet(OperatorEnum.MINUS,value);
                } else if (oper.equals(OperatorEnum.MODASSIGN)) {
                    setterMethod=createSetGet(OperatorEnum.MOD,value);
                } else if (oper.equals(OperatorEnum.MULTIASSIGN)) {
                    setterMethod=createSetGet(OperatorEnum.MULTI,value);
                } else if (oper.equals(OperatorEnum.ORASSIGN)) {
                    setterMethod=createSetGet(OperatorEnum.OR,value);
                } else if (oper.equals(OperatorEnum.PLUSASSIGN)) {
                    setterMethod=createSetGet(OperatorEnum.PLUS,value);
                } else if (oper.equals(OperatorEnum.RSHIFTASSIGN)) {
                    setterMethod=createSetGet(OperatorEnum.RSHIFT,value);
                } else if (oper.equals(OperatorEnum.URSHIFTASSIGN)) {
                    setterMethod=createSetGet(OperatorEnum.URSHIFT,value);
                } else if (oper.equals(OperatorEnum.XORASSIGN)) {
                    setterMethod=createSetGet(OperatorEnum.XOR,value);
                } else 
                    throw new IllegalArgumentException("Unknown operator "+oper); // NOI18N
            } else if (parent instanceof PrefixExpression) {
                PrefixExpression exp=(PrefixExpression)parent;
                IntLiteral one=model.getIntLiteral().createIntLiteral(1);
                Operator op=exp.getOperator();
                Operator newOp=OperatorEnum.PLUS;
                
                if (op.equals(OperatorEnum.DEC))
                    newOp=OperatorEnum.MINUS;
                setterMethod=createSetGet(newOp,one);
            } else 
                throw new IllegalArgumentException("Unknown type "+parent.getClass()); // NOI18N
            assignParent.replaceChild(parent, setterMethod);
        }
    }
}    
