/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring;

import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;

public class JavadocElement extends SimpleRefactoringElementImpl {
    ClassMember feature;
    int textoffset;
    String text;
    private String plainText;
    private PositionBounds bounds = null;
    private String htmlText;
    
    public JavadocElement(int offset,String txt,ClassMember f) {
        textoffset=offset;
        text=txt;
        feature=f;
        computeText();
    }

    public String getDisplayText() {
        return "/** "+htmlText;
    }

    public Element getJavaElement() {
        return feature;
    }

    public FileObject getParentFile() {
        return null;
    }

    public PositionBounds getPosition() {
        if (bounds == null) {
            bounds = JavaMetamodel.getManager().getElementPosition(feature.getJavadoc());
        }
        return bounds;
    }

    public String getText() {
        return plainText;
    }

    public void performChange() {
    }
    
    private void computeText() {
        String commentText=feature.getJavadocText();
        int start=commentText.lastIndexOf('\n', textoffset);
        int end=commentText.indexOf('\n', textoffset);
        StringBuffer htmlBuffer=new StringBuffer();
        
        if (end==-1) end=commentText.length();
        
        htmlBuffer.append("<i>");//NOI18N
        htmlBuffer.append(CheckUtils.htmlize(commentText.substring(start+1, textoffset)));
        htmlBuffer.append("<b>");//NOI18N
        htmlBuffer.append(commentText.substring(textoffset, textoffset+text.length()));
        htmlBuffer.append("</b>");//NOI18N
        htmlBuffer.append(CheckUtils.trimToEnd(CheckUtils.htmlize(commentText.substring(textoffset+text.length(), end))));
        htmlBuffer.append("</i>");//NOI18N
        htmlText=htmlBuffer.toString();
        plainText=commentText.substring(start+1, end);
    }
    
}
