/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import javax.jmi.reflect.RefObject;

public class WhereUsedElement extends SimpleRefactoringElementImpl {
    private final String text;
    private final String displayText;
    private final ElementPartKind displayPart;

    protected final RefObject jmiObject;
    protected final Element feature;
    protected final ElementPartKind changePart;
    //protected final HashSet indexes;

    // caches
    private RefObject comp = null;
    private PositionBounds bounds = null;

    public WhereUsedElement(RefObject jmiObject, Element feature) {
        assert feature != null : jmiObject;
        Resource r = feature.getResource();
        assert r != null: feature;

        String sourceText = r.getSourceText();
        this.feature = feature;
        this.jmiObject = jmiObject;

        StringBuffer displayText = new StringBuffer();
        final int startOffset, endOffset;
        int offset;

        Element displayElement = getDisplayElement();
        if (displayElement instanceof CallableFeature || (displayElement instanceof JavaClass && !(displayElement instanceof TypeParameter)) || displayElement instanceof Resource) {
            startOffset = displayElement.getPartStartOffset(ElementPartKindEnum.HEADER);
            endOffset = displayElement.getPartEndOffset(ElementPartKindEnum.HEADER);
        } else {
            int so = sourceText.lastIndexOf('\n', feature.getStartOffset());
            int eo = sourceText.indexOf('\n', feature.getEndOffset());
            startOffset = so == -1 ? 0 : so;
            endOffset = eo == -1 ? sourceText.length(): eo;
        }
        offset = startOffset;
        if (feature instanceof Feature) {
            if (feature instanceof CallableFeature) {
                displayPart = ElementPartKindEnum.HEADER;
                changePart = null;
                offset = appendText(displayText, sourceText, feature, ElementPartKindEnum.NAME, offset);
            } else if (feature instanceof JavaClass) {
                displayPart = ElementPartKindEnum.HEADER;
                JavaClass jc = (JavaClass) feature;
                changePart = null;
            } else if (feature instanceof Field) {
                displayPart = null;
                changePart = null;
                offset = appendText(displayText, sourceText, feature, changePart, offset);
            } else if (feature instanceof Resource) {
                displayPart = ElementPartKindEnum.HEADER;
                changePart = null;
            } else {
                throw new RuntimeException("Unknown type of object: " + feature.getClass().getName()); //NOI18N
            }
        } else {
            if (feature instanceof Invocation) {
                changePart = ElementPartKindEnum.NAME;
            } else if (feature instanceof Variable || feature instanceof TypeCast || feature instanceof ElementReference) {
                changePart = null;
            } else if (feature instanceof Import) {
                changePart = ElementPartKindEnum.NAME;
            } else if (feature instanceof Resource) {
                changePart = ElementPartKindEnum.HEADER;
            } else {
                throw new RuntimeException("Unknown type of object: " + feature.getClass().getName()); //NOI18N
            }
            displayPart = changePart;
            //indexes = null;
            offset = appendText(displayText, sourceText, feature, changePart, offset);
        }
        displayText.append(CheckUtils.htmlize(sourceText.substring(offset, endOffset)));
        this.displayText = normalize(displayText.toString().trim());
        this.text = normalize(sourceText.substring(startOffset, endOffset));
        this.getPosition();
    }

    private Element getDisplayElement() {
        if (feature instanceof Resource) {
            return feature;
        }
        if (feature instanceof Import) {
            return feature;
        }
        Element result = feature;
        while (!((result instanceof ClassMember) || (result instanceof Resource) || (result instanceof Import) ||
            (result.refImmediateComposite() instanceof StatementBlock))) {
            result = (Element) result.refImmediateComposite();
        }
        return result;
    }

    private String normalize(String text) {
        StringBuffer result = new StringBuffer(text.length());
        boolean whitespaces = false;
        for (int i = 0; i < text.length(); i++) {
            char ch = text.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (!whitespaces) {
                    whitespaces = true;
                    result.append(' ');
                }
            } else {
                result.append(ch);
                whitespaces = false;
            }
        }
        return result.toString();
    }

    private int appendText(StringBuffer result, String sourceText, Element feature, ElementPartKind part, int startOffset) {
        int offset = part != null ? feature.getPartStartOffset(part) : feature.getStartOffset();
        result.append(CheckUtils.htmlize(sourceText.substring(startOffset, offset)));
        result.append("<b>");//NOI18N
        startOffset = offset;
        offset = part != null ? feature.getPartEndOffset(part) : feature.getEndOffset();
        result.append(CheckUtils.htmlize(sourceText.substring(startOffset, offset)));
        result.append("</b>");//NOI18N
        return offset;
    }
    
    public String getDisplayText() {
        return displayText;
    }

    public Element getJavaElement() {
        if (comp == null) {
            comp = feature;
            while (!((comp instanceof Feature) || (comp instanceof Resource))) {
                comp = (RefObject) comp.refImmediateComposite();
            }
        }
        return (Element) comp;
    }

    public PositionBounds getPosition() {
        if (bounds == null) {
            if (displayPart == null) {
                bounds = JavaMetamodel.getManager().getElementPosition(feature);
            } else {
                bounds = JavaMetamodel.getManager().getElementPartPosition(feature, displayPart, 0);
            }
        }
        return bounds;
    }

    public String getText() {
        return text;
    }

    public void performChange() {
    }

    public FileObject getParentFile() {
        return null;
    }
}
